% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLupdater.R
\name{multiTranslateGLstring}
\alias{multiTranslateGLstring}
\title{Translate a Vector of GL Strings to a Desired IPD-IMGT/HLA Database Version}
\usage{
multiTranslateGLstring(GLstrings, from, to, expand = FALSE, verbose = FALSE)
}
\arguments{
\item{GLstrings}{A vector of GL Strings encoded in the same IPD-IMGT/HLA Database release version.}

\item{from}{A character string identifying the IPD-IMGT/HLA Database release version of 'GLstrings'.}

\item{to}{A character string identifying the IPD-IMGT/HLA Database release version to translate 'GLstrings' to. Values can range from version 1.05.0 to the loaded version of the alleleListHistory object.}

\item{expand}{A logical that indicates if the lowest-numbered truncated allele names that match truncated allele names in 'GLstrings' should be returned (expand = FALSE), or if a slash-delimited string of all matching full-length allele names should be returned (expand = TRUE). The default value is FALSE.}

\item{verbose}{A logical that indicates if messages regarding the trnslation process should be sent to the console (TRUE) or not (FALSE). The default value is FALSE.}
}
\value{
A version GLSCs (in a data frame) updated to the desired version. NA values are returned in place of alleles that are not present in 'to'.
}
\description{
Translates a column from a data frame in GL String Code format to a desired reference database version.
}
\examples{
multiGLs <- multiTranslateGLstring(GLstring.ex$Gl.String[1:50],"3.01.0","2.15.0")
multiGLs <- multiTranslateGLstring(GLstring.ex$Gl.String[1:50],"3.30.0","3.58.0")

}
\references{
Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126
}
