% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coint.R
\name{coint}
\alias{coint}
\title{Identifying conintegration rank of given time series}
\usage{
coint(
  Y,
  lag.k = 5,
  type = c("acf", "pptest", "chang", "all"),
  c0 = 0.3,
  m = 20,
  alpha = 0.01
)
}
\arguments{
\item{Y}{\eqn{{\bf Y} = \{{\bf y}_1, \dots , {\bf y}_n \}'}, a data matrix
with \eqn{n} rows and \eqn{p} columns, where \eqn{n} is the sample size and
\eqn{p} is the dimension of \eqn{{\bf y}_t}.}

\item{lag.k}{Time lag \eqn{k_0} used to calculate the nonnegative definte
matrix \eqn{\widehat{{\bf W}}_y}: \deqn{\widehat{\mathbf{W}}_y\ =\
\sum_{k=0}^{k_0}\widehat{\mathbf{\Sigma}}_y(k)\widehat{\mathbf{\Sigma}}_y(k)'}
 where \eqn{\widehat{\bf \Sigma}_y(k)} is the sample autocovariance of
\eqn{ \widehat{{\bf y}_t}} at lag \eqn{k}.}

\item{type}{The method of identifying cointegration rank after segment 
procedure. Option is \code{'acf'}, \code{'all'}, \code{'chang'} or \code{'pptest'}
, the latter two methods use the unit-root test method to identify the 
cointegration rank, and the option \code{type = 'all'} means use all three
methods to identify the cointegration rank. Default is \code{type = 'acf'}.
 See Sections 2.3 in Zhang, Robinson and Yao (2019) for more information.}

\item{c0}{The prescribed constant for identifying 
cointegration rank using \code{"acf"} method. Default is 0.3.[See (2.3) in
Zhang, Robinson and Yao (2019)].}

\item{m}{The prescribed constant for identifying 
cointegration rank using \code{"acf"} method. Default is 20. [See (2.3) in
Zhang, Robinson and Yao (2019)].}

\item{alpha}{The prescribed significance level for identifying 
cointegration rank using \code{"pptest","chang"} method. Default is 0.01.
[See (2.3) in Zhang, Robinson and Yao (2019)].}
}
\value{
A list containing the following components:

  \item{result}{A \eqn{1 \times 1} matrix representing the cointegration rank.
  If \code{'type' = 'all'}, then return a \eqn{1 \times 3} matrix representing
   the cointegration rank of all three methods.}
}
\description{
\code{coint} seeks for a contemporaneous linear
  transformation for a multivariate time series such that we can identifying 
  cointegration rank from the transformed series.
}
\examples{
p <- 10
n <- 1000
r <- 3
d <- 1
X <- mat.or.vec(p, n)
X[1,] <- arima.sim(n-d, model = list(order=c(0, d, 0)))
for(i in 2:3)X[i,] <- rnorm(n)
for(i in 4:(r+1)) X[i, ] <- arima.sim(model = list(ar = 0.5), n)
for(i in (r+2):p) X[i, ] <- arima.sim(n = (n-d), model = list(order=c(1, d, 1), ar=0.6, ma=0.8))
M1 <- matrix(c(1, 1, 0, 1/2, 0, 1, 0, 1, 0), ncol = 3, byrow = TRUE)
A <- matrix(runif(p*p, -3, 3), ncol = p)
A[1:3,1:3] <- M1
Y <- t(A\%*\%X)
coint(Y, type = "all")
}
\references{
Zhang, R., Robinson, P. & Yao, Q. (2019).  \emph{Identifying 
Cointegration by Eigenanalysis}.  Journal of the American Statistical 
Association, Vol. 114, pp. 916--927
}
