% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_multi.R
\name{MG}
\alias{MG}
\title{MG scan procedure}
\usage{
MG(
  data,
  MC = 999,
  typeI = 0.05,
  nbCPU = 1,
  variable_names = NULL,
  initialization,
  permutations
)
}
\arguments{
\item{data}{matrix. Matrix of the data, the rows correspond to the sites (or the individuals if the observations are by individuals and not by sites) and each column represents a variable.}

\item{MC}{numeric. Number of Monte-Carlo permutations to evaluate the statistical significance of the clusters. By default: 999.}

\item{typeI}{numeric. The desired type I error. A cluster will be evaluated as significant if its associated p-value is less than typeI. By default 0.05.}

\item{nbCPU}{numeric. Number of CPU. If nbCPU > 1 parallelization is done. By default: 1.}

\item{variable_names}{character. Names of the variables. By default NULL.}

\item{initialization}{list. Initialization for the scan procedure (see \code{\link{InitScan}} for more details).}

\item{permutations}{matrix. Indices of permutations of the data.}
}
\value{
An object of class ResScanOutputMulti.
}
\description{
This function computes the MG (Multivariate Gaussian scan statistic).
}
\references{
Lionel Cucala and Michaël Genin and Caroline Lanier and Florent Occelli (2017). A Multivariate Gaussian Scan Statistic for Spatial Data. Spatial Statistics, 21, 66-74.
}
