% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{simuXY}
\alias{simuXY}
\title{Simulate the data of hidden compact representation model.}
\usage{
simuXY(sample_size = 2000, min_nx = 3, max_nx = 15, min_ny = 3,
  max_ny = 15, type = 0, distribution = "multinomial")
}
\arguments{
\item{sample_size}{Sample size}

\item{min_nx}{The minimum value of |X| (Default: 3)}

\item{max_nx}{The maximum value of |X| (Default: 15)}

\item{min_ny}{The minimum value of |Y| (Default: 3)}

\item{max_ny}{The maximum value of |Y| (Default: 15)}

\item{type}{type=0: standard version, type=1: |X|=|Y|, type=2: |Y'|=|Y|, type=3: |X|=|Y'|, type=4: |X|=|Y'|=|Y| (Default: type=0)}

\item{distribution}{The distribution of the cause X. The options are "multinomial","geom","hyper","nbinom","pois". Default: multinomial}
}
\value{
return the synthetic data
}
\description{
Generate the X->Y pair HCR data
}
\examples{
df=simuXY(sample_size=100,type=0)
length(unique(df[,1]))
length(unique(df[,2]))
length(unique(df[,3]))

df=simuXY(sample_size=100,type=1)
length(unique(df[,1]))
length(unique(df[,3]))

df=simuXY(sample_size=100,type=2)
length(unique(df[,2]))
length(unique(df[,3]))

df=simuXY(sample_size=100,type=3)
length(unique(df[,1]))
length(unique(df[,2]))

df=simuXY(sample_size=100,type=4)
length(unique(df[,1]))
length(unique(df[,2]))
length(unique(df[,3]))

}
