% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Precip_model}
\alias{Precip_model}
\title{Altitude gradient based precipitation models}
\usage{
Precip_model(
       model,
       inputData,
       zmeteo,
       ztopo,
       param
)
}
\arguments{
\item{model}{numeric value with model option:
\itemize{
  \item 1: linear precipitation gradient (LP).
  \item 2: linear precipitation gradient with an upper threshold (LPM).
}}

\item{inputData}{numeric vector with precipitation gauge series \eqn{[mm/\Delta t]}.}

\item{zmeteo}{numeric value indicating the altitude of the precipitation gauge \eqn{[masl]}.}

\item{ztopo}{numeric value with the target height \eqn{[masl]}.}

\item{param}{numeric vector with the following parameters:

\strong{LP}
\itemize{
  \item 1: precipitation gradient (\code{gradP}) [\%/100m].
}

\strong{LPM}
\itemize{
  \item 1: precipitation gradient (\code{gradP}) [\%/100m].
  \item 2: threshold height. Precipitation does not increase when the altitude (\code{ztopo})
  is higher than this parameter \eqn{[masl]}.
}}
}
\value{
Numeric vector with the extrapolated precipitation series.
}
\description{
Extrapolate precipitation gauge measurements to another heights. In this package
version you can use the classical linear gradient model or a modified version which
sets a threshold altitude for precipitation increment (avoiding unreliable estimations).
}
\examples{
# The following is a toy example. I strongly recommend to see
# the package vignettes in order to improve your skills on HBV.IANIGLA

## LP case
set.seed(369)

precLP <- Precip_model(model = 1, inputData = runif(n = 365, max = 30, min = 0),
                        zmeteo = 3000, ztopo = 4700, param = c(5))

## LPM case
set.seed(369)

precLPM <- Precip_model(model = 2, inputData = runif(n = 365, max = 30, min = 0),
                        zmeteo = 3000, ztopo = 4700, param = c(5, 4500))

}
\references{
For some interesting work on precipitation gradients at catchment and
synoptic scale see:

Immerzeel, W.W., Petersen, L., Ragettli, S., Pellicciotti, F., 2014.
The importance of observed gradients of air temperature and precipitation for modeling
runoff from a glacierized watershed in the Nepalese Himalayas.
Water Resour. Res. 50, 2212–2226. https://doi.org/10.1002/2013WR014506

Viale, M., Nuñez, M.N., 2010. Climatology of Winter Orographic Precipitation over the
Subtropical Central Andes and Associated Synoptic and Regional Characteristics.
J. Hydrometeorol. 12, 481–507. https://doi.org/10.1175/2010JHM1284.1
}
