% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_adj.r
\name{aucadj}
\alias{aucadj}
\title{R function for optimism-adjusted AUC (internal validation)}
\usage{
aucadj(data, fit, B = 200)
}
\arguments{
\item{data}{Dataframe containing the dataset (note: the Dependent Variable must be stored in the
first column to the left).}

\item{fit}{Object returned from glm() function.}

\item{B}{Desired number of bootstrap resamples (suggested values: 100 or 200; the latter is used by default).}
}
\value{
The returned boxplots represent:\cr -the distribution of the AUC value in the bootstrap
  sample (auc.boot), which represents "an estimation of the apparent performance" (according to
  the aforementioned reference);\cr -the distribution of the AUC value deriving from the model
  fitted to the bootstrap samples and evaluated on the original sample (auc.orig), which
  represents the model performance on independent data.\cr At the bottom of the chart, the
  apparent AUC (i.e., the value deriving from the model fitted to the original dataset) and the
  AUC adjusted for optimism are reported.
}
\description{
The function allows to calculate the AUC of a (binary) Logistic Regression model, adjusted for
optimism.\cr
}
\details{
The function performs an internal validation of a model via a bootstrap procedure (devised by
Harrell and colleagues), which enables to estimate the degree of optimism of a fitted model and
the extent to which the model will be able to generalize outside the training dataset. If you
want more info, you can refer to this website
(http://thestatsgeek.com/2014/10/04/adjusting-for-optimismoverfitting-in-measures-of-predictive-ability-using-bootstrapping/),
and/or read the following interesting article (in which the bootstrap procedure is described at
page 776):
http://thestatsgeek.com/2014/10/04/adjusting-for-optimismoverfitting-in-measures-of-predictive-ability-using-bootstrapping/\cr
}
\examples{
# load the sample dataset
data(log_regr_data)

# fit a logistic regression model, storing the results into an object called 'model'
model <- glm(admit ~ gre + gpa + rank, data = log_regr_data, family = "binomial")

aucadj(data=log_regr_data, fit=model, B=200)

}
\seealso{
\code{\link{logregr}} , \code{\link{modelvalid}}
}
\keyword{aucadj}
