% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rounding_hashing_thinning.R
\name{rounding_hashing_thinning}
\alias{rounding_hashing_thinning}
\title{Rounding Hashing Thinning}
\usage{
rounding_hashing_thinning(
  coordinates,
  thin_dist = 10,
  trials = 10,
  all_trials = FALSE,
  euclidean = FALSE,
  R = 6371,
  seed = NULL
)
}
\arguments{
\item{coordinates}{A numeric matrix of size (n x 2) containing the longitude and latitude of points, where each row represents a coordinate pair.}

\item{thin_dist}{A numeric value specifying the distance (in kilometers) within which points should be considered for thinning.}

\item{trials}{An integer indicating the number of trials to run for the thinning process. More trials may yield better results.}

\item{all_trials}{A logical value indicating whether to return all trials (`TRUE`) or only the best trial (`FALSE`).}

\item{euclidean}{Logical value indicating whether to compute the Euclidean distance (`TRUE`) or Haversine distance (`FALSE`, default).}

\item{R}{A numeric value representing the radius of the Earth in kilometers. Default is set to 6371.0 km.}

\item{seed}{Optional; an integer seed for reproducibility of results.}
}
\value{
A logical vector indicating which points are kept after the thinning process. If `all_trials` is `TRUE`, a list of logical vectors will be returned, one for each trial.
}
\description{
Performs thinning of geographical coordinates using a hashing approach and rounds the coordinates to create a grid.
}
\details{
This function applies a hashing technique to group coordinates into grid cells, allowing for efficient thinning based on a specified distance.
It can run multiple trials to determine the best set of points to keep, or return all trials if specified.
}
\examples{
# Generate random coordinates
set.seed(123)
coordinates <- matrix(runif(20, min = -180, max = 180), ncol = 2) # 10 random points

# Perform rounding hashing thinning
result <- rounding_hashing_thinning(coordinates, thin_dist = 10, trials = 5)
print(result)

# Perform thinning with all trials
all_results <- rounding_hashing_thinning(coordinates, thin_dist = 5000, trials = 5,
                                         all_trials = TRUE)
print(all_results)

# Perform thinning with euclidean distance
result_euclidean <- rounding_hashing_thinning(coordinates, thin_dist = 10,
                                              trials = 5, euclidean = TRUE)
print(result_euclidean)
}
