% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNA_seq.R
\name{diff_RNA}
\alias{diff_RNA}
\title{Do difference analysis of RNA-seq data}
\usage{
diff_RNA(counts, group, method = "limma", geneLength = NULL, gccontent = NULL)
}
\arguments{
\item{counts}{a dataframe or numeric matrix of raw counts data}

\item{group}{sample groups}

\item{method}{one of "DESeq2", "edgeR" and "limma".}

\item{geneLength}{a vector of gene length.}

\item{gccontent}{a vector of gene GC content.}
}
\description{
Do difference analysis of RNA-seq data
}
\examples{
\dontrun{
library(TCGAbiolinks)
                
query <- GDCquery(project = "TCGA-ACC",
                  data.category = "Transcriptome Profiling",
                  data.type = "Gene Expression Quantification", 
                  workflow.type = "HTSeq - Counts")
                  
GDCdownload(query, method = "api", files.per.chunk = 3, 
    directory = Your_Path)

dataRNA <- GDCprepare(query = query, directory = Your_Path,
                      save = TRUE, save.filename = "dataRNA.RData")
## get raw count matrix                         
dataPrep <- TCGAanalyze_Preprocessing(object = dataRNA,
                                      cor.cut = 0.6,
                                      datatype = "HTSeq - Counts")

# Use `diff_RNA` to do difference analysis
## Random value is used as gene length and GC content.
geneLength <- sample(1000:2000, nrow(dataPrep), replace = TRUE)
names(geneLength) <- colnames(dataPrep)
gccontent <- runif(nrow(dataPrep))
names(gccontent) <- colnames(dataPrep)
## Random value is used as sample group.
group <- sample(c("grp1", "grp2"), ncol(dataPrep), replace = TRUE)
library(cqn) # To avoid reporting errors: there is no function "rq"
DEGAll <- diff_RNA(counts = dataPrep, group = group, 
                   geneLength = geneLength, gccontent = gccontent)
}
}
