% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareInput.R
\name{prepareInput}
\alias{prepareInput}
\title{Prepares input data list for the model estimation with estimateModel()
function.}
\usage{
prepareInput(
  response = NULL,
  locObs = NULL,
  likelihood,
  jScale = NULL,
  urban = NULL,
  mesh.s = NULL,
  adminMap = NULL,
  nSubAPerPoint = 10,
  nSubRPerPoint = 10,
  covariateData = NULL
)
}
\arguments{
\item{response}{A list containing the number of trials (ns) and number of
successes (ys) for the binomial response, response
values (ys) for the Gaussian response or the Poisson counts for the Poisson
response.}

\item{locObs}{A matrix containing the coordinates of DHS
survey cluster centers in kilometers.}

\item{likelihood}{A value indicating which likelihood should be used
(0, 1 or 2 for Gaussian, binomial or Poisson, respectively).}

\item{jScale}{Jittering scale, where 1 represents the default DHS jittering
scheme.}

\item{urban}{A vector containing the urbanization classification of the
administrative area that each cluster center is initially located within
(U for urban and R for rural).}

\item{mesh.s}{A triangulation mesh.}

\item{adminMap}{A SpatialPolygonsDataFrame object containing the borders of
the administrative area level, which was respected while the cluster centers
were initially being jittered (can be obtained from https://gadm.org).}

\item{nSubAPerPoint}{A value representing the number of unique
sub-integration point angles per integration point.}

\item{nSubRPerPoint}{A value representing the number of unique
sub-integration point radii per integration point.}

\item{covariateData}{A list containing the covariate rasters.}
}
\value{
A list containing the input for estimateModel() function.
}
\description{
Prepares input data list for the model estimation with estimateModel()
function.
}
\examples{
if(requireNamespace("INLA")){
path1 <- system.file("extdata", "geoData.rda", package = "GeoAdjust")
path2 <- system.file("extdata", "exampleMesh.rda", package = "GeoAdjust")
load(path1)
load(path2)
inputData <- prepareInput(response = list(ys = surveyData$ys, ns = surveyData$ns),
locObs = cbind(surveyData$east, surveyData$north),
likelihood = 1, jScale = 1,
urban = surveyData$urbanRural, mesh.s = exampleMesh, adminMap = adm1,
nSubAPerPoint = 10, nSubRPerPoint = 10,
covariateData = NULL)
}
}
