% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_noise_nn.R
\name{estimate_noise_nn}
\alias{estimate_noise_nn}
\title{Estimate the standard deviation (noise) of the nugget term in nnGP}
\usage{
estimate_noise_nn(
  hyperparam,
  w_obs,
  GPS_obs,
  y_obs,
  n_neighbor,
  nthread,
  kernel_fn = function(x) exp(-x^2)
)
}
\arguments{
\item{hyperparam}{A vector of hyper-parameter values.}

\item{w_obs}{A vector of observed exposure levels.}

\item{GPS_obs}{A vector of estimated GPS evaluated at the observed exposure
levels.}

\item{y_obs}{A vector of observed outcomes.}

\item{n_neighbor}{A number of nearest neighbors on one side.}

\item{nthread}{A number of cores used in the estimation.}

\item{kernel_fn}{The covariance function of the GP.}
}
\value{
A scalar of estimated standard deviation of the nugget term in nnGP.
}
\description{
Estimates the standard deviations of the nugget term (noise) in nnGP by
calculating the standard deviations of the residuals.
}
\keyword{internal}
