% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.ss.bin.int.ocplot.r
\name{make.ss.bin.int.ocplot}
\alias{make.ss.bin.int.ocplot}
\title{Make single sample binary interim OC curve}
\usage{
make.ss.bin.int.ocplot(
  ss.bin.studyend.GNG,
  ss.bin.int.oc,
  ss.bin.int.GNG,
  ss.bin.int.df,
  goThreshold = 0.8,
  nogoThreshold = 0.8,
  include_nogo = TRUE,
  lower = 0,
  upper = 1
)
}
\arguments{
\item{ss.bin.studyend.GNG}{call to get.ss.bin.studyend.GNG}

\item{ss.bin.int.oc}{call to get.ss.bin.interim.oc}

\item{ss.bin.int.GNG}{call to get.ss.bin.interim.GNG}

\item{ss.bin.int.df}{call to get.ss.bin.int.df}

\item{goThreshold}{predictive probability threshold for interim}

\item{nogoThreshold}{predictive probability threshold for interim}

\item{include_nogo}{logical}

\item{lower}{lower bound}

\item{upper}{upper bound}
}
\value{
A ggplot object is returned
}
\description{
make.ss.bin.interim.ocplot - creates OC curve with Final and Any Interim
}
\examples{
\donttest{
my.ss.bin.studyend.GNG = get.ss.bin.studyend.GNG(a.trt = 1, b.trt = 1, n.trt = 40, x.trt = 9,
                                      Delta.lrv = .2, Delta.tv = .35,
                                      tau.tv = 0.10, tau.lrv = .80, tau.ng = .65)
my.ss.bin.int.df <- get.ss.bin.int.df(ss.bin.studyend.GNG = my.ss.bin.studyend.GNG,
                                      goThreshold = .8, nogoThreshold = .8, include_nogo =TRUE)
my.ss.bin.int.GNG <- get.ss.bin.int.GNG(ss.bin.int.df = my.ss.bin.int.df,
                                    Interims = 20,
                                    ss.bin.studyend.GNG = my.ss.bin.studyend.GNG)
my.ss.bin.int.oc <- get.ss.bin.int.oc(ss.bin.int.df = my.ss.bin.int.df,
ss.bin.int.GNG= my.ss.bin.int.GNG)
 my.ss.bin.int.ocplot <- make.ss.bin.int.ocplot(
                 ss.bin.studyend.GNG = my.ss.bin.studyend.GNG,
                 ss.bin.int.oc = my.ss.bin.int.oc,
                 ss.bin.int.GNG=my.ss.bin.int.GNG,
                 ss.bin.int.df = my.ss.bin.int.df,
                 goThreshold = .8,
                 nogoThreshold = .8,
                 include_nogo =TRUE, lower=0, upper=1)
my.ss.bin.int.ocplot
}
}
