% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ts.bin.trt.oc.df.r
\name{get.ts.bin.trt.oc.df}
\alias{get.ts.bin.trt.oc.df}
\title{Get two-sample binary treatment OC data.frame}
\usage{
get.ts.bin.trt.oc.df(
  a.con = 1,
  b.con = 1,
  dcurve.con = 0.12,
  a.trt = 1,
  b.trt = 1,
  TE.OC.N = 80,
  Aratio = 2,
  TE.OC.Delta.LB = 0,
  TE.OC.Delta.UB = 1 - 0.12,
  Delta.tv = 0.35,
  Delta.lrv = 0.2,
  tau.tv = 0.01,
  tau.lrv = 0.8,
  tau.ng = 0.65
)
}
\arguments{
\item{a.con}{prior alpha parameter for control group}

\item{b.con}{prior beta parameter for control group}

\item{dcurve.con}{Response rate for control group}

\item{a.trt}{prior alpha parameter for treatment group}

\item{b.trt}{prior beta parameter for treatment group}

\item{TE.OC.N}{total sample size for OC}

\item{Aratio}{Randomization ratio}

\item{TE.OC.Delta.LB}{Lower bound for OC curve}

\item{TE.OC.Delta.UB}{Upper bound for OC curve}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}
}
\value{
A data.frame is returned that allows for creation of treatment effect operating characteristics curve
}
\description{
Get two-sample binary treatment OC data.frame
}
\examples{
\donttest{
my.ts.bin.trt.oc.df <- get.ts.bin.trt.oc.df()
head(my.ts.bin.trt.oc.df)
}
}
\references{
Sverdlov O, Ryeznik Y, Wu S. Exact Bayesian Inference Comparing Binomial Proportions, With Application to Proof-of-Concept Clinical Trials. Therapeutic Innovation & Regulatory Science. 2015;49(1):163-174. doi:10.1177/2168479014547420
}
