% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmatrix_print.R
\name{print.ggmatrix}
\alias{print.ggmatrix}
\title{Print ggpair object}
\usage{
\method{print}{ggmatrix}(x, leftWidthProportion = 0.2,
  bottomHeightProportion = 0.1, spacingProportion = 0.03, ...)
}
\arguments{
\item{x}{ggpair object to be plotted}

\item{leftWidthProportion}{proportion of a plot area devoted to left axis labels}

\item{bottomHeightProportion}{proportion of a plot area devoted to bottom axis labels}

\item{spacingProportion}{proportion of a plot area devoted to the space between plots}

\item{...}{ignored}
}
\description{
Specialized method to print the ggpair object-
}
\examples{
 data(tips, package = "reshape")
 pMat <- ggpairs(tips, c(1,3,2), color = "sex")
 pMat # calls print(pMat), which calls print.ggmatrix(pMat)

 ## defaults; (prints strips on top and right edges of matrix)
 # print(pMat, left = 0.2, spacing = 0.03, bottom = 0.1)

 ## give the left axis labels area a proportion of 3 plot size
 # print(pMat, leftWidthProportion = 3)

 ## give the bottom axis labels area a proportion of 1 plot size
 # print(pMat, bottomHeightProportion = 1)

 ## give the spacing between plots a proportion of 1 plot size
 # print(pMat, spacing = 1)
}
\author{
Barret Schloerke \email{schloerke@gmail.com}
}

