% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmncv.R
\name{plot.ggmncv}
\alias{plot.ggmncv}
\title{Plot \code{ggmncv} Objects}
\usage{
\method{plot}{ggmncv}(x, size = 1, alpha = 0.5, ...)
}
\arguments{
\item{x}{An object of class \code{\link{ggmncv}}.}

\item{size}{Numeric. Line size in \code{geom_line}.}

\item{alpha}{Numeric. The transparency of the lines.}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the solution path for the partial correlations.
}
\examples{
\donttest{
# data
Y <- GGMncv::ptsd[,1:10]

# correlations
S <- cor(Y, method = "spearman")

# fit model
# default: atan
fit <- ggmncv(R = S, n = nrow(Y), progress = FALSE)

# plot
plot(fit)

# lasso
fit <- ggmncv(R = S, n = nrow(Y), progress = FALSE,
              penalty = "lasso")

# plot
plot(fit)
}
}
