% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes.r
\name{plot.global_envelope}
\alias{plot.global_envelope}
\title{Plot method for the class 'global_envelope'}
\usage{
\method{plot}{global_envelope}(
  x,
  dotplot = length(x$r) < 10,
  sign.col = "red",
  labels = NULL,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{An 'global_envelope' object}

\item{dotplot}{Logical. If TRUE, then instead of envelopes a dot plot is done.
Suitable for low dimensional test vectors.
Default: TRUE if the dimension is less than 10, FALSE otherwise.}

\item{sign.col}{The color for the observed curve when outside the global envelope
(significant regions). Default to "red". Setting the color to \code{NULL} corresponds
to no coloring. If the object contains several envelopes, the coloring is done for
the widest one.}

\item{labels}{A character vector of suitable length.
If \code{dotplot = TRUE}, then labels for the tests at x-axis.}

\item{digits}{The number of digits used for printing the p-value or p-interval
in the default main.}

\item{...}{Ignored.}
}
\description{
Plot method for the class 'global_envelope'
}
\examples{
if(require("spatstat.explore", quietly=TRUE)) {
  X <- unmark(spruces)
  \donttest{nsim <- 1999 # Number of simulations}
  \dontshow{nsim <- 19 # Number of simulations}
  env <- envelope(X, fun="Kest", nsim=nsim,
                  savefuns=TRUE, # save the functions
                  correction="translate", # edge correction for K
                  simulate=expression(runifpoint(ex=X))) # Simulate CSR
  res <- global_envelope_test(env, type="erl")

  # Default plot
  plot(res)
  # Plots can be edited, e.g.
  # Remove legend
  plot(res) + ggplot2::theme(legend.position="none")
  # Change its position
  plot(res) + ggplot2::theme(legend.position="right")
  # Change the outside color
  plot(res, sign.col="#5DC863FF")
  plot(res, sign.col=NULL)
  # Change default title and x- and y-labels
  plot(res) + ggplot2::labs(title="95\% global envelope", x="x", y="f(x)")

  # Prior to the plot, you can set your preferred ggplot theme by theme_set
  old <- ggplot2::theme_set(ggplot2::theme_bw())
  plot(res)

  # Do other edits, e.g. turn off expansion with the default limits
  plot(res) + ggplot2::coord_cartesian(expand=FALSE)

  # Go back to the old theme
  ggplot2::theme_set(old)

  # If you are working with the R package spatstat and its envelope-function,
  # you can obtain global envelope plots in the style of spatstat using plot.fv:
  plot.fv(res)
}
}
\seealso{
\code{\link{central_region}}, \code{\link{global_envelope_test}}
}
