% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appl_indeptest.r
\name{GET.contingency}
\alias{GET.contingency}
\title{Test of independence in a 2D contingency table}
\usage{
GET.contingency(X, nsim = 999, ...)
}
\arguments{
\item{X}{A matrix with n rows and 2 columns. Each row contains
one bivariate observation.}

\item{nsim}{The number of random permutations used.}

\item{...}{Additional parameters to be passed to \code{\link{global_envelope_test}}.
In particularly, \code{alpha} specifies the nominal significance level of the test,
and \code{type} the type of the global envelope test.}
}
\description{
Permutation-based test of independence in a 2D contingency table,
using the matrix of observed counts as the test statistic.
}
\details{
Permutation-based test of independence in a 2D contingency table,
using the matrix of observed counts as the test statistic.

If the observed data are the pairs \eqn{\{(X_1, Y_1), \ldots, (X_n, Y_n)\}}{{(X_1, Y_1), ..., (X_n, Y_n)}},
the permutations are obtained by randomly permuting the values
in the second marginal, i.e. \eqn{\{(X_1, Y_{\pi(1)}), \ldots, (X_n, Y_{\pi(n)})\}}{{(X_1, Y_{pi(1)}), ..., (X_n, Y_{pi(n)})}}.

The test itself is performed using the global envelope test in the chosen version.
Text output can be printed in the console by typing the object name.
The cells in which the observed value exceeds the upper envelope printed in red,
and cells in which the observed value is lower than the lower
envelope printed in cyan. Standard output of the global envelope
test is also returned and can be plotted or analyzed accordingly.
}
\examples{
# Generate sample data:
data <- matrix(c(sample(4, size=100, replace=TRUE), sample(2, size=100, replace=TRUE)), ncol=2)
data[,2] <- data[,2] + data[,1]

# Observed contingency table (with row names and column names)
table(data[,1], data[,2])

# Permutation-based envelope test
\donttest{res <- GET.contingency(data, nsim=999)}
\dontshow{res <- GET.contingency(data, nsim=19)}
res
plot(res)

# Extract the p-value
attr(res,"p")
}
\references{
Dvořák, J. and Mrkvička, T. (2022). Graphical tests of independence for general distributions. Computational Statistics 37, 671--699.
}
