% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportedFuncs.R
\name{att.structure}
\alias{att.structure}
\title{Generate hierarchical attribute structures}
\usage{
att.structure(hierarchy.list = NULL, K, Q, att.prob = "uniform")
}
\arguments{
\item{hierarchy.list}{a list specifying the hierarchical structure between attributes. Each
element in this list specifies a DIRECT prerequisite relation between two or more attributes.
See \code{example} for more information.}

\item{K}{the number of attributes involved in the assessment}

\item{Q}{Q-matrix}

\item{att.prob}{How are the probabilities for latent classes simulated? It can be \code{"random"} or \code{"uniform"}.}
}
\value{
att.str reduced latent classes under the specified hierarchical structure

impossible.latentclass impossible latent classes under the specified hierarchical structure

att.prob probabilities for all latent classes; 0 for impossible latent classes
}
\description{
This function can be used to generate hierarchical attributes structures, and
to provide prior joint attribute distribution with hierarchical structures.
}
\examples{
\dontrun{
#################
#
# Leighton et al. (2004, p.210)
#
##################
# linear structure A1->A2->A3->A4->A5->A6
K <- 6
linear=list(c(1,2),c(2,3),c(3,4),c(4,5),c(5,6))
att.structure(linear,K)

# convergent structure A1->A2->A3->A5->A6;A1->A2->A4->A5->A6
K <- 6
converg <- list(c(1,2),c(2,3),c(2,4),
               c(3,4,5), #this is how to show that either A3 or A4 is a prerequisite to A5
               c(5,6))
att.structure(converg,K)

# convergent structure [the difference between this one and the previous one is that
#                       A3 and A4 are both needed in order to master A5]
K <- 6
converg2 <- list(c(1,2),c(2,3),c(2,4),
               c(3,5), #this is how to specify that both A3 and A4 are needed for A5
               c(4,5), #this is how to specify that both A3 and A4 are needed for A5
               c(5,6))
att.structure(converg2,K)

# divergent structure A1->A2->A3;A1->A4->A5;A1->A4->A6
diverg <- list(c(1,2),
               c(2,3),
               c(1,4),
               c(4,5),
               c(4,6))
att.structure(diverg,K)

# unstructured A1->A2;A1->A3;A1->A4;A1->A5;A1->A6
unstru <- list(c(1,2),c(1,3),c(1,4),c(1,5),c(1,6))
att.structure(unstru,K)

## See Example 4 and 5 in GDINA function
}
}
\seealso{
\code{\link{GDINA}}, \code{\link{autoGDINA}}
}
\author{
{Wenchao Ma, The University of Alabama, \email{wenchao.ma@ua.edu} \cr Jimmy de la Torre, The University of Hong Kong}
}
