% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GDI.R, R/extract.R, R/summary.GDINA.R
\name{Qval}
\alias{Qval}
\alias{extract.Qval}
\alias{summary.Qval}
\title{Q-matrix validation}
\usage{
Qval(GDINA.obj, method = "PVAF", eps = 0.95, digits = 4,
  wald.args = list())

\method{extract}{Qval}(object, what = c("sug.Q", "varsigma", "PVAF",
  "eps", "Q"), ...)

\method{summary}{Qval}(object, ...)
}
\arguments{
\item{GDINA.obj}{An estimated model object of class \code{GDINA}}

\item{method}{which Q-matrix validation method is used? Can be either \code{"PVAF"} or \code{"wald"}.}

\item{eps}{cutoff value for PVAF from 0 to 1. Default = 0.95. Note that it can also be -1, indicating the predicted cutoff based on Najera, P., Sorrel, M., and Abad, P. (2019).}

\item{digits}{How many decimal places in each number? The default is 4.}

\item{wald.args}{a list of arguments for the stepwise Wald test method.
\describe{
\item{SE.type}{Type of covariance matrix for the Wald test}
\item{alpha.level}{alpha level for the wald test}
\item{GDI}{It can be 0, 1 or 2; 0 means GDI is not used to choose the attribute -
when more than one attributes are significant, the one with the largest p-value will be selected;
GDI=1 means the attribute with the largest GDI will be selected; GDI=2 means the q-vector with
the largest GDI will be selected.}
\item{verbose}{Print detailed information or not?}
\item{stepwise}{\code{TRUE} for stepwise approach and \code{FALSE} for forward approach}
}}

\item{object}{\code{Qval} objects for S3 methods}

\item{what}{argument for S3 method \code{extract} indicating what to extract;
It can be \code{"sug.Q"} for suggested Q-matrix,
\code{"Q"} for original Q-matrix, \code{"varsigma"} for varsigma index,
and \code{"PVAF"} for PVAF.}

\item{...}{additional arguments}
}
\value{
An object of class \code{Qval}. Elements that can be
extracted using \code{extract} method include:
\describe{
\item{sug.Q}{suggested Q-matrix}
\item{Q}{original Q-matrix}
\item{varsigma}{varsigma index}
\item{PVAF}{PVAF}
}
}
\description{
Q-matrix validation for the (sequential) G-DINA model based on PVAF (de la Torre & Chiu, 2016; Najera, Sorrel, & Abad, 2019), stepwise Wald test (Ma & de la Torre, 2019) or mesa plot (de la Torre & Ma, 2016).
All these methods are suitable for dichotomous and ordinal response data. If too many modifications are suggested based on the default PVAF method, you are suggested to try the stepwise Wald test method or predicted cutoffs.
You should always check the mesa plots for further examination.
}
\section{Methods (by generic)}{
\itemize{
\item \code{extract}: extract various elements from \code{Qval} objects

\item \code{summary}: print summary information
}}

\examples{
\dontrun{
################################
#
# Binary response
#
################################
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ
Q[10,] <- c(0,1,0)

# Fit the G-DINA model
mod1 <- GDINA(dat = dat, Q = Q, model = "GDINA")

# Q-validation using de la Torre and Chiu's method
pvaf <- Qval(mod1,method = "PVAF",eps = 0.95)
pvaf
extract(pvaf,what = "PVAF")
#See also:
extract(pvaf,what = "varsigma")
extract(pvaf,what = "sug.Q")

# Draw mesa plots using the function plot

plot(pvaf,item=10)

#The stepwise Wald test
stepwise <- Qval(mod1,method = "wald")
stepwise
extract(stepwise,what = "PVAF")
#See also:
extract(stepwise,what = "varsigma")
extract(stepwise,what = "sug.Q")

#Set eps = -1 to determine the cutoff empirically
pvaf2 <- Qval(mod1,method = "PVAF",eps = -1)
pvaf2
################################
#
# Ordinal response
#
################################
seq.est <- GDINA(sim20seqGDINA$simdat,sim20seqGDINA$simQ,sequential = TRUE)
stepwise <- Qval(seq.est, method = "wald", eps = -1)
}
}
\references{
de la Torre, J. & Chiu, C-Y. (2016). A General Method of Empirical Q-matrix Validation. \emph{Psychometrika, 81}, 253-273.

de la Torre, J., & Ma, W. (2016, August). Cognitive diagnosis modeling: A general framework approach and its implementation in R. A Short Course at the Fourth Conference on Statistical Methods in Psychometrics, Columbia University, New York.

Ma, W. & de la Torre, J. (2019). An Empirical Q-Matrix Validation Method for the Sequential G-DINA Model. \emph{British Journal of Mathematical and Statistical Psychology}

Najera, P., Sorrel, M., & Abad, P. (2019). Reconsidering Cutoff Points in the General Method of Empirical Q-Matrix Validation. \emph{Educational and Psychological Measurement}.
}
\seealso{
\code{\link{GDINA}}
}
\author{
{Wenchao Ma, The University of Alabama, \email{wenchao.ma@ua.edu} \cr Jimmy de la Torre, The University of Hong Kong}
}
