% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frac20.R
\docType{data}
\name{frac20}
\alias{frac20}
\title{Tatsuoka's fraction subtraction data}
\format{A list of responses and Q-matrix with components:
\describe{
\item{\code{dat}}{responses of 536 examinees to 20 items}
\item{\code{Q}}{The \eqn{20 \times 8} Q-matrix}
}}
\usage{
frac20
}
\description{
Fraction Subtraction data consists of responses of 536 examinees to 20 items measuring 8 attributes.
The data set is obtained from \url{http://onlinelibrary.wiley.com/journal/10.1111/(ISSN)1467-9876/homepage/series_c_datasets.htm}.
}
\examples{
\dontrun{
mod1 <- GDINA(frac20$dat,frac20$Q,model="DINA")
mod1
summary(mod1)
# Higher order model
mod2 <- GDINA(frac20$dat,frac20$Q,model="DINA",higher.order=TRUE)
mod2
anova(mod1,mod2)
}
}
\references{
Tatsuoka, C. (2002). Data analytic methods for latent partially ordered classification models. \emph{Journal of the Royal Statistical Society, Series C, Applied Statistics, 51}, 337-350.
}
\keyword{datasets}
