#' GCPBayes Package
#'
#' @description
#' Run a Gibbs sampler for a multivariate Bayesian sparse group selection model with Dirac, continuous and hierarchical spike prior for detecting pleiotropic effects on multiple traits. This package is designed for summary statistics containing estimated regression coefficients and their estimated covariance matrices.
#'
#' @docType package
#'
#' @keywords CS
#' @keywords DS
#' @keywords HS
#' @keywords summaryCS
#' @keywords summaryDS
#' @keywords summaryHS
#' @keywords MCMCplot
#'
#' @author Taban Baghfalaki \email{t.baghfalaki@gmail.com}, \email{t.baghfalaki@modares.ac.ir}
#'
#' @references
#' \enumerate{
#' \item
#' Baghfalaki, T., Sugier, P. E., Truong, T., Pettitt, A. N., Mengersen, K., & Liquet, B. (2021). Bayesian meta analysis models for cross cancer genomic investigation of pleiotropic effects using group structure. \emph{Statistics in Medicine}, \strong{40}(6), 1498-1518.
#'
#' \item
#' Baghfalaki, T., Sugier, Y. Asgari, P. E., Truong, & Liquet, B. (2021). GCPBayes:  An R Package for Studying Cross-Phenotype Genetic Associations with Group-Level Bayesian Meta-Analysis. \emph{Submitted}.
#' }
#' @name GCPBayes
#'
NULL
