% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minP.R
\name{minP}
\alias{minP}
\title{minP.R}
\usage{
minP(test_stats, cor_mat = NULL, pairwise_cors = NULL)
}
\arguments{
\item{test_stats}{Vector of test statistics for each factor in the set (i.e. marginal
test statistic for each SNP in a gene)}

\item{cor_mat}{d*d matrix of the correlations between all the test statistics in
the set, where d is the total number of test statistics in the set.
You only need to specify EITHER cor_mat OR pairwise_cors.}

\item{pairwise_cors}{A vector of all d(d-1)/2 pairwise correlations between the test
statistics. You only need to specify EITHER cor_mat OR pairwise_cors.}
}
\value{
A list with the elements:
\item{minP}{The observed MinimumP test statistic.}
\item{minP_pvalue}{The p-value of this observed value, given the size of the set and
correlation structure.}
}
\description{
Given a vector of individual test statistics and their pairwise correlations, calculate
the MinimumP (see Conneely and Boehnke, 2007) second-level test statistic and it's p-value.
}
\examples{
# Should return statistic = 0.05918928 and p_value = 0.2525972.
set.seed(100)
Z_vec <- rnorm(5) + rep(1,5)
cor_Z <- matrix(data=0.2, nrow=5, ncol=5)
diag(cor_Z) <- 1
minP(test_stats=Z_vec, cor_mat=cor_Z)
}

