% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RemoveNotFuzzy.R
\name{RemoveNotFuzzy}
\alias{RemoveNotFuzzy}
\title{Removing values that are not fuzzy numbers.}
\usage{
RemoveNotFuzzy(trueData, imputedData, trapezoidal = TRUE, ...)
}
\arguments{
\item{trueData}{Name of the input matrix (data frame(or data frame)) that is used to restore erroneous fuzzy numbers.}

\item{imputedData}{Name of the input matrix (data frame) with fuzzy numbers to check their correctness.}

\item{trapezoidal}{Logical value depending on the type of fuzzy values (triangular or trapezoidal ones) in the dataset.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is given as a matrix.
}
\description{
`RemoveNotFuzzy` removes all values that are not proper fuzzy numbers and restores the previous ones.
}
\details{
The procedure checks all the values in the given matrix (or data frame) specified by \code{imputedData}
and if some of them are not proper fuzzy numbers (e.g., their cores are outside the supports), they are removed.
Instead of these erroneous values, the previous ones from the input matrix (a data frame, or a list) \code{trueData} are restored.
These matrices (or data frames) should consist of fuzzy numbers (triangular fuzzy numbers if \code{trapezoidal=FALSE} is set,
 or trapezoidal ones if the default \code{trapezoidal=TRUE} is used).
The output is given as a matrix where each row is related to fuzzy numbers (with 3 values for the triangular fuzzy numbers,
or 4 values in the case of trapezoidal ones) for the consecutive variables.
The input has to consist of fuzzy numbers of the same type (i.e., mixing triangular and trapezoidal fuzzy numbers is not allowed).
}
\examples{

# matrix with proper values of triangular fuzzy numbers

matrixOK <- matrix(c(1,2,3,7,10,12,8,10,11),ncol=3,byrow = TRUE)

# matrix with the wrong third value of fuzzy triangular number (its core is greater than
# the left end of its support) 

matrixFalse <- matrix(c(1,2,3,7,10,12,8,20,11),ncol=3,byrow = TRUE)

# remove the third value and restore the previous one

RemoveNotFuzzy(matrixOK,matrixFalse,trapezoidal = FALSE)


}
