% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatrixToFuzzyNumbers.R
\name{MatrixToFuzzyNumbers}
\alias{MatrixToFuzzyNumbers}
\title{Conversion of a matrix to a list of fuzzy numbers.}
\usage{
MatrixToFuzzyNumbers(fuzzyMatrix, varNames = NA, ...)
}
\arguments{
\item{fuzzyMatrix}{Name of the matrix with fuzzy numbers.}

\item{varNames}{Optional names for values of the output list.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is given as a list of fuzzy numbers.
}
\description{
`MatrixToFuzzyNumbers` converts a matrix into a list of triangular or trapezoidal fuzzy numbers.
}
\details{
The procedure converts the given matrix to a list of triangular or trapezoidal fuzzy numbers.
If the input matrix has 3 columns, then they are treated as descriptions of consecutive triangular fuzzy
numbers.
In the case of 4 columns, we get trapezoidal fuzzy numbers.
The values in these columns are equal to
the left supports, cores (or left and right ends of the cores for trapezoidal fuzzy 
numbers) and right supports. 
Each row is related to single fuzzy number.
}
\examples{


library(FuzzyNumbers)

# prepare matrix with 2 triangular fuzzy numbers

matrix1 <- matrix(c(1,3,5,2,5,7),ncol=3,byrow = TRUE)

# convert this matrix to list of fuzzy numbers

MatrixToFuzzyNumbers(matrix1)


}
\seealso{
\code{\link{FuzzyNumbersToMatrix}} for conversion of a list of fuzzy numbers into a matrix.
}
