% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwcs.R
\name{mcws}
\alias{mcws}
\title{Marker-Controlled Watershed Segmentation}
\usage{
mcws(treetops, CHM, minHeight = 0, format = "raster", OSGeoPath = NULL,
  verbose = FALSE)
}
\arguments{
\item{treetops}{\link[sp:SpatialPoints]{SpatialPointsDataFrame}. The point locations of treetops. The function will generally produce a
number of crown segments equal to the number of treetops.}

\item{CHM}{Canopy height model in \link[raster]{raster} format. Should be the same that was used to create
the input for \code{treetops}.}

\item{minHeight}{numeric. The minimum height value for a \code{CHM} pixel to be considered as part of a crown segment.
All \code{CHM} pixels beneath this value will be masked out. Note that this value should be lower than the minimum
height of \code{treetops}.}

\item{format}{string. Format of the function's output. Can be set to either 'raster' or 'polygons'.}

\item{OSGeoPath}{character. Optional path to the OSGeo4W installation directory. If both OSGeo4W and Python are installed,
this will enable the function to use a faster algorithm for producing polygonal crown outlines (see Details below).}

\item{verbose}{logical. Print processing progress to console.}
}
\value{
Depending on the argument set with \code{format}, this function will return a map of outlined
crowns as either a RasterLayer (see \link[raster]{raster}), in which distinct crowns
are given a unique cell value, or a \link[sp:SpatialPolygons]{SpatialPolygonsDataFrame}, in which each crown
is represented by a polygon.
}
\description{
Implements the \link[imager]{watershed} function to segment (i.e.: outline) crowns from a canopy height model.
Segmentation is guided by the point locations of treetops, typically detected using the \link{vwf} function.
See Meyer & Beucher (1990) for details on watershed segmentation.
}
\details{
This function can return a crown map as either a \link[raster]{raster} or a \link[sp:SpatialPolygons]{SpatialPolygonsDataFrame},
as defined using the \code{format} argument. For most analytical purposes, it is preferable to have
crown outlines as polygons. However, polygonal crown maps take up significantly more disk space, and take
longer to process. It is advisable to run this function using a raster output first, in order to check
its results and adjust parameters.

Using the 'polygons' output \code{format} provides the added benefit of transferring
treetop attributes (such as \emph{height}) to the newly created polygons. The area of each crown will also
automatically be calculated and added to the polygons' data under the \emph{crownArea} field. Furthermore,
"orphaned" segments (i.e.: outlines without an associated treetop) will be removed when
\code{format} is set to 'polygons'.

By default, polygonal crown outlines are produced internally using the the \code{rasterToPolygons} function from
the \link[raster]{raster} package. This function is problematic due to it being 1) very slow and 2) leaking memory
when applied to multiple datasets. An alternative is provided for users who've installed OSGeo4W and Python.
By setting the \code{OSGeoPath} path to the OSGeo4W installation directory (usually 'C:\\OSGeo4W64'), the function will
use the \emph{gdal_polygonize.py} GDAL utility to generate polygonal crown outlines instead.
}
\examples{
# Use variable window filter to detect treetops in demo canopy height model
ttops <- vwf(CHMdemo, winFun = function(x){x * 0.06 + 0.5}, minHeight = 2)

# Set minimum tree crown height (should be LOWER than minimum treetop height)
minCrwnHgt <- 1

# Use 'mcws' to outline tree crowns
segs <- mcws(ttops, CHMdemo, minCrwnHgt)

}
\references{
Meyer, F., & Beucher, S. (1990). Morphological segmentation. \emph{Journal of visual communication and
image representation, 1}(1), 21-46.
}
\seealso{
\code{\link{vwf}} \code{\link{sp_summarise}} \code{\link[imager]{watershed}} \cr \cr
OSGeo4W download page: \url{https://trac.osgeo.org/osgeo4w/}
}
