% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulatedIncidenceMatrix

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{SimulatedIncidenceMatrix}
\alias{SimulatedIncidenceMatrix}
\title{SimulatedIncidenceMatrix}
\description{A class for storing lists of IncidenceMatrices}
\seealso{
Inherits from : \code{\link{AbstractSimulatedIncidenceMatrix}}

}
\examples{
data = IncidenceMatrix$new(matrix(1:9,3,3))
data = SimulatedIncidenceMatrix$new(data,3)
data$addError('Poisson')
data$simulations
data$sample$mat
data$mat
data$sample$mat
data$mat
data$nrow
data$ncol
data$nsim
data$dims
data$ndim
data$ndim
data$addRows(2)
data$addColumns(3)
data$simulations
data$head(2,1)
data$head(3,2)
data$simulations
data$mean()$mat
data$median()$mat
data$scale(mutate=FALSE,function(x)\{x+3\})$mat
class(data$summarize(function(x)\{sum(x)\}))
data$summarize(function(x)\{sum(x)\})$mat
data$simulations
}
\section{Fields}{
\describe{
\item{arr}{This is the full array.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{cnames}{The names of columns in the data.}
\item{colData}{A list of metadata associated with the columns of the data.}
\item{dimData}{The data associated with each dimension of the array.}
\item{dims}{The size of the array.}
\item{dnames}{The size of the array.}
\item{mat}{A matrix containing a single sample.  By default, it is the first sample.  See \code{self$sample} for how to change it.}
\item{metaData}{Any data not part of the main data structure.}
\item{ncol}{The number of columns in the data.}
\item{ndim}{The number of dimensions of the array.}
\item{nrow}{The number of rows in the data}
\item{nsim}{The number of simulations in \code{self$simulaions}}
\item{rnames}{The names of rows in the data.}
\item{rowData}{A list of metadata associated with the rows of the data.}
\item{sample}{Return a random sample from the simulations.  Alternatively, select a sample to use with \code{self$mat} by assigning a value.}
\item{simulations}{The simulations this structure is responsible for.  This is another name for \code{self$arr}.}
}}
\section{Methods}{
\methodname{addColumns(columns)}{
This function adds columns to \code{self$simulations}
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{columns}{The number of columns to add.}
}}}}
\methodname{addError(type,rows,cols,mutate = TRUE)}{
Add error to the simulations according to a distribution.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{type}{The type of distribution as a string.  Currently 'Poisson' is allowed.}
\methoditem{rows}{Which rows to affect.}
\methoditem{cols}{Which columns to affect.}
\methoditem{mutate}{Whether to modify this object, or create and return a modified object.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{addRows(rows)}{
This function adds rows to \code{self$simulations}
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{rows}{The number of rows to add.}
}}}}
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{diff(lag = 1,mutate=TRUE)}{
This function replaces the matrix value at column i with the differences between the values at column \code{i} and \code{i-lag}.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{lag}{How far back to diff.}
\methoditem{mutate}{Whether to modify this object, or create and return a modified object.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{head(k,direction=2,mutate=FALSE)}{
Take the first \code{k} slices of \code{self$simulations}
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{k}{How many slices to keep}
\methoditem{direction}{Which dimension to take a subset of.  1 is rows, 2 is columns, 3 is simulations}
\methoditem{mutate}{Whether to modify this object, or create and return a modified object.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{initialize(data=MatrixData$new(),nsim=1)}{
Create a new SimulatedIncidenceMatrix.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{The data to use for the simulation.  Can be a list of IncidenceMatrices, or a single IncidenceMatrix.}
\methoditem{nsim}{The number of simulations.  If \code{data} is a list, this should be the length of the list.  If \code{data} is an IncidenceMatrix, this is the number of times the IncidenceMatrix is replicated.}
}}}}
\methodname{lag(indices,mutate = TRUE,na.rm=FALSE)}{
This function replaces the current matrix with a new matrix with one column for every column, and a row for every row/index combination.  The column corresponding to the row and index will have the value of the original matrix in the same row, but index columns previous.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{indices}{A sequence of lags to use as part of the data.  Note that unless this list contains \\code{0}, the data will all be shifted back by one year.}
\methoditem{mutate}{Whether to modify this object, or create and return a modified object.}
\methoditem{na.rm}{Whether to remove the NA columns that result where the lag goes off the edge of self$simulations.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{lead(indices,mutate = TRUE,na.rm=FALSE)}{
This function replaces the current array with a new array with one column for every column, and a row for every row/index combination.  The column corresponding to the row and index will have the value of the original array in the same row, but index columns ahead.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{indices}{A sequence of leads to use as part of the data.  Note that unless this list contains \\code{0}, the data will all be shifted back by at least one year.}
\methoditem{mutate}{Whether to modify this object, or create and return a modified object.}
\methoditem{na.rm}{Whether to remove the NA columns that result where the lead goes off the edge of self$simulations.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{mean()}{
Compute the mean over all simulations.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}
\item{Value}{An IncidenceMatrix where return$mat is the elementwise mean of self$arr}
}}
\methodname{median()}{
Compute the median over all simulations.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}
\item{Value}{An IncidenceMatrix where return$mat is the elementwise median of self$arr}
}}
\methodname{mutate(rows,cols,data)}{
This function changes the information stored in \code{self$simulations}
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{rows}{The rows to change.}
\methoditem{cols}{The columns to change.}
\methoditem{data}{The data to change to.  Can be either array-like or matrix-like.  If its matrix-like it will overwrite all of the dimensions.}
}}}}
\methodname{scale(f,mutate=TRUE)}{
This function rescales each element of our object according to a function.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{f}{The function we rescale by.  This function takes in a number and outputs a rescaled version of that number.}
\methoditem{mutate}{Whether to modify this object, or create and return a modified object.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{subsample(simulations,mutate=TRUE)}{
Choose only some of the simulations.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{simulations}{Which simulations to keep}
\methoditem{mutate}{Whether to modify this object, or create and return a modified object.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{subset(rows,cols,mutate=TRUE)}{
Take a subset of the object as though it were a matrix.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{rows}{Numeric, named, or logical denoting which rows to select}
\methoditem{cols}{Numeric, named, or logical denoting which columns to select}
\methoditem{mutate}{Whether to modify this object, or create and return a modified object.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{summarize(FUNC,...)}{
Apply a function to every simulation.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{FUNC}{The function to apply.}
\methoditem{\dots}{Any arguments to \code{FUNC} other than the matrix.}
}}
\item{Value}{An IncidenceMatrix where \code{return$mat[i,j]} is the same as \code{FUNC(self$arr[i,j,])}}
}}
\methodname{tail(k,direction=2)}{
Take the last \code{k} slices of \code{self$simulations}
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{k}{How many slices to keep}
\methoditem{direction}{Which dimension to take a subset of.  1 is rows, 2 is columns, 3 is simulations}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
