% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hts_tools.R
\name{hts_tools}
\alias{hts_tools}
\title{Cross-sectional reconciliation tools}
\usage{
hts_tools(C, h = 1, Ut, nb, sparse = TRUE)
}
\arguments{
\item{C}{(\code{na x nb}) cross-sectional (contemporaneous) matrix mapping the bottom
level series into the higher level ones.}

\item{h}{Forecast horizon (\emph{default} is \code{1}).}

\item{Ut}{(\code{na x n}) zero constraints cross-sectional (contemporaneous) kernel
matrix \eqn{\textbf{U}'\textbf{Y} = \mathbf{0}_{\left[n_a \times (k^*+m)\right]}}{}
spanning the null space valid for the reconciled forecasts. It can be used instead of
parameter \code{C}, but needs \code{nb} (n = na + nb).}

\item{nb}{Number of bottom time series; if \code{C} is present, \code{nb} is not used.}

\item{sparse}{Option to return sparse object (\emph{default} is \code{TRUE}).}
}
\value{
A list of five elements:
\item{\code{S}}{(\code{n x nb}) cross-sectional (contemporaneous) summing matrix.}
\item{\code{Ut}}{(\code{na x n}) zero constraints cross-sectional (contemporaneous)
kernel matrix.}
\item{\code{n}}{Number of variables \code{na + nb}.}
\item{\code{na}}{Number of upper level variables.}
\item{\code{nb}}{Number of bottom level variables.}
}
\description{
Some useful tools for the cross-sectional reconciliation of linearly and hierarchically constrained time series
}
\examples{
# One level hierarchy (na = 1, nb = 2)
obj <- hts_tools(C = matrix(c(1, 1), 1), sparse = FALSE)
}
\keyword{utilities}
