% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hasRSV.R
\name{hasRSV}
\alias{hasRSV}
\title{Does object have a term for RSV?}
\usage{
hasRSV(x)
}
\arguments{
\item{x}{An object of class \code{\link[=fitFluMoDL]{FluMoDL}} or
\code{\link{summary.FluMoDL}}}
}
\value{
\code{TRUE} if the model contains a term for RSV, \code{FALSE} if it does not.
}
\description{
This method checks whether a 'FluMoDL' or 'summary.FluMoDL' object contains a
\code{\link[dlnm:crossbasis]{cross-basis term}} for RSV (Respiratory Syncytial Virus)
incidence proxy, or contains only terms for influenza incidence proxies.
}
\examples{
data(greece) # Use example surveillance data from Greece
m <- with(greece, fitFluMoDL(deaths = daily$deaths,
    temp = daily$temp, dates = daily$date,
    proxyH1 = weekly$ILI * weekly$ppH1,
    proxyH3 = weekly$ILI * weekly$ppH3,
    proxyB = weekly$ILI * weekly$ppB,
    yearweek = weekly$yearweek))
hasRSV(m)   # Returns FALSE
hasRSV(summary(m))   # Also returns FALSE

}
