#' @title B_plot_normalised
#'
#' @description Function to plot B-factor normalised values per amino acid using a bar plot; NOTE: some PDB files have breakages in their amino acid sequence, that is some residues might be missing and the gaps will be reflected in the plot
#'
#' @param pdb_df Requires a PDB data frame generated by PDB_prepare
#' @return  bar plot
#'
#' @ImportFrom ggplot2 aes
#' @ImportFrom ggplot2 ggplot
#' @ImportFrom ggplot2 geom_bar
#' @ImportFrom ggplot2 scale_x_continuous
#' @ImportFrom ggplot2 scale_y_continuous
#' @ImportFrom ggplot2 xlab
#' @ImportFrom ggplot2 ylab
#' @ImportFrom ggplot2 ggtitle
#' @ImportFrom plotly  ggplotly
#' @export
#' @examples
#' path_to_processed_PDB<- system.file("extdata", "pdb_df.tabular", package="Fiscore")
#' # basic usage of B_plot_normalised
#' pdb_df<-read.table(path_to_processed_PDB)
#' B_plot_normalised(pdb_df)

B_plot_normalised<-function(pdb_df){

  #to avoid namespace conflucts
  df_resno_val<-pdb_df$"df_resno"
  B_normalised_val<-pdb_df$"B_normalised"

  plot_bar<-ggplot2::ggplot(pdb_df) + ggplot2::geom_bar(ggplot2::aes(x=df_resno_val, y = B_normalised_val), color="grey", alpha=0.2, stat = "identity")+ggplot2::scale_x_continuous(expand = c(0,0))+ggplot2::ggtitle(label="B factor normalised value distribution")+ggplot2::xlab(label="Residue number")+ggplot2::ylab(label="B factor normalised")

  plotly::ggplotly(plot_bar)



}
