% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_estimation.R
\name{elevenprobs}
\alias{elevenprobs}
\alias{fiveprobs}
\alias{sevenprobs}
\title{Eleven, Seven, Five Probabilities}
\usage{
elevenprobs(X, parnames = FALSE)

sevenprobs(X, parnames = FALSE)

fiveprobs(X, parnames = FALSE)
}
\arguments{
\item{X}{numeric. Vector of quantiles.}

\item{parnames}{boolean. Output parameter vector with or without names.}
}
\description{
Extract from a dataset \code{X} a vector of 11, 7 or 5 probabilities: 
\itemize{
  \item{ \code{c(p1, p2, p3, 0.25, 0.35, 0.50, 0.65, 0.75, 1-p3, 1-p2, 1-p1)} }
  \item{ \code{c(p1, p2, 0.25, 0.50, 0.75, 1-p2, 1-p1)} }
  \item{ \code{c(p1, 0.25, 0.50, 0.75, 1-p1)} }
}
where p1, p2 and p3 are the most extreme probabilities of the dataset \code{X} 
with values finishing either by \code{.x01} or \code{.x025} or \code{.x05}. 
Parameters names are displayed if \code{parnames = TRUE}.
}
\examples{

require(timeSeries)

## DS
DS  <- getDSdata()
for (j in 1:16) { print(round(elevenprobs(DS[[j]]), 6)) }
z   <- cbind(t(sapply(DS, elevenprobs)), sapply(DS, length))
colnames(z) <- c("p1","p2","p3","p.25","p.35","p.50","p.65","p.75","1-p3","1-p2","1-p1","length")
z

## Choose j in 1:16
j   <- 1
X   <- sort(DS[[j]])
leX <- logit(eX <- elevenprobs(X))
lpX <- logit(ppoints(length(X), a = 0))
plot(X, lpX)
abline(h = leX, lty = 3)
mtext(eX, side = 4, at = leX, las = 1, line = -3.3)



}
\seealso{
\code{\link{fitkienerX}}, \code{\link{estimkiener11}}.
}

