% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{adjust_frm}
\alias{adjust_frm}
\title{Adjust an existing FastRet model for use with a new column}
\usage{
adjust_frm(
  frm = train_frm(),
  new_data = read_rpadj_xlsx(),
  predictors = 1:6,
  nfolds = 5,
  verbose = 1
)
}
\arguments{
\item{frm}{An object of class \code{frm} as returned by \code{\link[=train_frm]{train_frm()}}.}

\item{new_data}{Dataframe with columns "RT", "NAME", "SMILES" and optionally a set of chemical descriptors.}

\item{predictors}{Numeric vector specifying which predictors to include in the model in addition to RT. Available options are: 1=RT, 2=RT^2, 3=RT^3, 4=log(RT), 5=exp(RT), 6=sqrt(RT).}

\item{nfolds}{An integer representing the number of folds for cross validation.}

\item{verbose}{A logical value indicating whether to print progress messages.}
}
\value{
An object of class \code{frm}, which is a list with the following elements:
\itemize{
\item \code{model}: A list containing details about the original model.
\item \code{df}: The data frame used for training the model.
\item \code{cv}: A list containing the cross validation results.
\item \code{seed}: The seed used for random number generation.
\item \code{version}: The version of the FastRet package used to train the model.
\item \code{adj}: A list containing details about the adjusted model.
}
}
\description{
The goal of this function is to train a model that predicts RT_ADJ (retention time measured on a new, adjusted column) from RT (retention time measured on the original column) and to attach this "adjustmodel" to an existing FastRet model.
}
\examples{
\donttest{
frm <- read_rp_lasso_model_rds()
new_data <- read_rpadj_xlsx()
frmAdjusted <- adjust_frm(frm, new_data, verbose = 0)
}
}
\keyword{public}
