% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcubp0.R
\name{fastcubp0}
\alias{fastcubp0}
\title{Main function for CUB models with covariates for the uncertainty component}
\usage{
fastcubp0(m,ordinal,Y,starting=NULL,maxiter,toler,iterc=3,invgen=TRUE,verbose=FALSE)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of selected covariates for explaining the uncertainty component}

\item{starting}{Starting values for the algorithm}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}

\item{iterc}{Iteration from which the acceleration strategy starts}

\item{invgen}{Logical: should the recursive formula for the inverse of the information matrix be considered? (Default is TRUE)}

\item{verbose}{Logical: should messages about  acceleration steps be printed out? (Default is FALSE)}
}
\value{
An object of the class "fastCUB"
}
\description{
Estimate and validate a CUB model for given ordinal responses, with covariates for explaining 
the feeling component via a logistic transform.
}
\keyword{internal}
