% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectPercentile}
\alias{selectPercentile}
\title{Select Percentile}
\usage{
selectPercentile(data, class, featureEval, percentile = 10)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureEval}{\itemize{
\item The measure used to evaluate features
}}

\item{percentile}{\itemize{
\item Number (positive integer) between 0 and 100
}

\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{featuresSelected}{The names of the returned features sorted according to the result of the evaluation measure}
\item{valuePerFeature}{The evaluation measures of the returned features}
}}
}
\description{
Selects a fraction, given as a percentage, of the total number of available features
}
\examples{
## Select Percentile for iris dataset (filter method)
selectPercentile(iris, 'Species', giniIndex, 80) # 80\% best features
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
