% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectKBest}
\alias{selectKBest}
\title{Select K best}
\usage{
selectKBest(data, class, featureEval, k = 1)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureEval}{\itemize{
\item The measure used to evaluate features
}}

\item{k}{\itemize{
\item Number (positive integer) of returned features
}}
}
\value{
A list is returned containing:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{featuresSelected}{The names of the k returned features sorted according to the result of the evaluation measure}
\item{valuePerFeature}{The evaluation measures of the k returned features}
}
}
\description{
Takes the 'k' features with the greatest evaluations
}
\examples{
## Select K best for iris dataset (filter method)
selectKBest(iris, 'Species', roughsetConsistency, 2) # 2 best features
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
