% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_gain.R
\name{information_gain}
\alias{information_gain}
\title{Entropy-based Filters}
\usage{
information_gain(formula, data, x, y, type = c("infogain", "gainratio",
  "symuncert"), equal = FALSE, threads = 1)
}
\arguments{
\item{formula}{An object of class \link{formula} with model description.}

\item{data}{A \link{data.frame} accompanying formula.}

\item{x}{A \link{data.frame} or sparse matrix with attributes.}

\item{y}{A vector with response variable.}

\item{type}{Method name.}

\item{equal}{A logical. Whether to discretize dependent variable with the
\code{equal frequency binning discretization} or not.}

\item{threads}{Number of threads for parallel backend.}
}
\value{
data.frame with the following columns:
\itemize{
 \item{attributes}{ - variables names.}
 \item{importance}{ - worth of the attributes.}
}
}
\description{
Algorithms that find ranks of importance of discrete attributes, basing on their entropy with a continous class attribute. This function
is a reimplementation of \pkg{FSelector}'s \link[FSelector]{information.gain},
\link[FSelector]{gain.ratio} and \link[FSelector]{symmetrical.uncertainty}.
}
\details{
\code{type = "infogain"} is \deqn{H(Class) + H(Attribute) - H(Class,
Attribute)}{H(Class) + H(Attribute) - H(Class, Attribute)}

\code{type = "gainratio"} is \deqn{\frac{H(Class) + H(Attribute) - H(Class,
Attribute)}{H(Attribute)}}{(H(Class) + H(Attribute) - H(Class, Attribute)) /
H(Attribute)}

\code{type = "symuncert"} is \deqn{2\frac{H(Class) + H(Attribute) - H(Class,
Attribute)}{H(Attribute) + H(Class)}}{2 * (H(Class) + H(Attribute) - H(Class,
Attribute)) / (H(Attribute) + H(Class))}

where H(X) is Shannon's Entropy for a variable X and H(X, Y) is a conditional
Shannon's Entropy for a variable X with a condition to Y.
}
\examples{

irisX <- iris[-5]
y <- iris$Species

## data.frame interface
information_gain(x = irisX, y = y)

# formula interface
information_gain(formula = Species ~ ., data = iris)
information_gain(formula = Species ~ ., data = iris, type = "gainratio")
information_gain(formula = Species ~ ., data = iris, type = "symuncert")

# sparse matrix interface
library(Matrix)
i <- c(1, 3:8); j <- c(2, 9, 6:10); x <- 7 * (1:7)
x <- sparseMatrix(i, j, x = x)
y <- c(1, 1, 1, 1, 2, 2, 2, 2)

information_gain(x = x, y = y)
information_gain(x = x, y = y, type = "gainratio")
information_gain(x = x, y = y, type = "symuncert")

}
\author{
Zygmunt Zawadzki \email{zygmunt@zstat.pl}
}
