% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{geomean}
\alias{geomean}
\alias{geosd}
\title{Calculates the geometric mean or geometric standard deviation.}
\usage{
geomean(x, na.rm = FALSE, zneg.rm = FALSE)

geosd(x, na.rm = FALSE, zneg.rm = FALSE)
}
\arguments{
\item{x}{Vector of numeric values.}

\item{na.rm}{Logical indicating whether to remove missing values or not.}

\item{zneg.rm}{Logical indicating whether to ignore or remove zero or negative values found in \code{x}.}
}
\value{
A numeric value that is the geometric mean or geometric standard deviation of the numeric values in \code{x}.
}
\description{
Calculates the geometric mean or standard deviation of a vector of numeric values.
}
\details{
The geometric mean is computed by log transforming the raw data in \code{x}, computing the arithmetic mean of the transformed data, and back-transforming this mean to the geometric mean by exponentiating.

The geometric standard deviation is computed by log transforming the raw data in \code{x}, computing the arithmetic standard deviation of the transformed data, and back-transforming this standard deviation to the geometric standard deviation by exponentiating.
}
\note{
This function is largely an implementation of the code suggested by Russell Senior on R-help in November, 1999.
}
\examples{
## generate random lognormal data
d <- rlnorm(500,meanlog=0,sdlog=1)
# d has a mean on log scale of 0; thus, gm should be exp(0)~=1
# d has a sd on log scale of 1; thus, gsd should be exp(1)~=2.7
geomean(d)
geosd(d)

## Demonstrate handling of zeroes and negative values
x <- seq(0,5)
# this will given an error
try(geomean(x))
# this will only give a warning, but might not be what you want
geomean(x,zneg.rm=TRUE)

}
\seealso{
See \code{\link[psych]{geometric.mean}} in \pkg{psych} and \code{\link[DescTools]{Gmean}} for geometric mean calculators.  See \code{\link[DescTools]{Gsd}} for geometric standard deviation calculators.
}
\keyword{misc}

