% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpotVA1.R
\docType{data}
\name{SpotVA1}
\alias{SpotVA1}
\title{Age and length of spot.}
\format{A data frame of 403 observations on the following 2 variables:
 \describe{
   \item{tl}{Measured total lengths (in inches)}
   \item{age}{Ages assigned from examination of otoliths}
 }}
\source{
Extracted from Table 1 in Chapter 8 (Spot) of the VMRC Final Report on Finfish Ageing, 2002 by the Center for Quantitative Fisheries Ecology at Old Dominion University.
}
\description{
Ages (from otoliths) and lengths of Virginia Spot (\emph{Leiostomus xanthurus}).
}
\details{
Final length measurements were simulated by adding a uniform error to the value at the beginning of the length category.
}
\section{Topic(s)}{

 \itemize{
   \item Growth
   \item von Bertalanffy
 }
}
\examples{
data(SpotVA1)
str(SpotVA1)
head(SpotVA1)
plot(tl~age,data=SpotVA1)

}
\seealso{
See \code{\link[FSAdata]{SpotVA2}} in \pkg{FSAdata} for related data.
}
\concept{
Growth 'von Bertalanffy'
}
\keyword{datasets}

