% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/basisfns.R
\docType{methods}
\name{nbasis}
\alias{nbasis}
\alias{nbasis,Basis_obj-method}
\alias{nbasis,SRE-method}
\title{Number of basis functions}
\usage{
nbasis(.Object)

\S4method{nbasis}{Basis_obj}(.Object)

\S4method{nbasis}{SRE}(.Object)
}
\arguments{
\item{.Object}{object of class \code{Basis} or \code{SRE}}
}
\description{
Retrieve the number of basis functions from \code{Basis} or \code{SRE} object.
}
\examples{
library(sp)
data(meuse)
coordinates(meuse) = ~x+y # change into an sp object
G <- auto_basis(manifold = plane(),data=meuse,nres = 2,regular=2,prune=10,type = "Gaussian")
print(nbasis(G))
}
