% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/romberg_alg.R
\name{romberg_alg}
\alias{romberg_alg}
\title{Romberg integration}
\usage{
romberg_alg(xbasis, bbasis)
}
\arguments{
\item{xbasis}{basis functional data object used to represent functional covariate \code{X}. If covariate is a scalar variable,
\code{xbasis} is a constant basis functional data object}

\item{bbasis}{basis functional data object used to represent beta regression coefficient function for each independent variable}
}
\value{
\item{S matrix}{  a matrix of inner product of two basis objects. The dimensions of the matrix
are determined by the number of basis functions. The number of rows is equal to the number of basis functions for \code{X},
and the number of columns is equal to the number of basis functions for \code{beta} regression coefficient functions.}
}
\description{
Romberg integration is a process of numerical integration. Composite Trapezoidal Rule is used for the approximation of an integral. Then, Richardson
extrapolation is used in order to improve previously computed approximations. The range over which the integral is defined is the range in which functional data are defined.
When the relative error is infinitesimally small, convergence criterion is fulfilled.
}
