% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{find.stationary.location}
\alias{find.stationary.location}
\title{find undknown calibration location}
\usage{
find.stationary.location(Proc.data, calibration.start, calibration.stop,
  plot = TRUE, initial.coords = NULL, print.optimization = TRUE,
  reltol = 1e-04)
}
\arguments{
\item{Proc.data}{processed data object generated by \code{\link{get.tags.data}}}

\item{calibration.start}{POSIXct time when stationary period started}

\item{calibration.stop}{POSIXct time when stationary period ended}

\item{plot}{plots every iteration}

\item{initial.coords}{location vector with initial values for location (longitude and latitude). Should be close (+-2000 km from the real location)}

\item{print.optimization}{do you want every optimization iteration to be printed? If TRUE - Lon, Lat, Calbration mean and Calibration sd are being printed. Optimization tries to minimze the latter.}

\item{reltol}{tolerance for optimization, see \code{\link{optim}} for more details}
}
\description{
Functions attempts to find a location where 
The function attempts to find a location for a time period assuming animal was not moving. Does not work well will shaded data!
}
\details{
The idea behind the function is that it tries to minimze variance between slopes for the whole period by optimizing location. It can be seen as an extension of Hill-Ekstrom calibration idea.
}
\examples{
#this example takes about 15 minutes to run
\dontrun{
File<-system.file("extdata", "Godwit_TAGS_format.csv", package = "FLightR")
Proc.data<-get.tags.data(File)
plot_slopes_by_location(Proc.data=Proc.data, location=c(5.43, 52.93))
abline(v=as.POSIXct("2013-08-20")) # end of first calibration period
abline(v=as.POSIXct("2014-05-05")) # start of the second calibration period
Location<-find.stationary.location(Proc.data, '2013-07-20', '2013-08-20', initial.coords=c(10, 50))
}
}
\author{
Eldar Rakhimberdiev
}

