\name{GAPintegerized}
\alias{GAPintegerized}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
An advanced version of \code{GAP()}.
}
\description{
See the description of \code{mFLSSSparIntegerized()}.
}
\usage{
GAPintegerized(
  maxCore = 7L,
  agentsCosts,
  agentsProfits,
  agentsBudgets,
  heuristic = FALSE,
  precisionLevel = integer(length(agentsBudgets)),
  returnBeforeMining = FALSE,
  tlimit = 60,
  useBiSrchInFB = FALSE,
  threadLoad = 8L,
  verbose = TRUE
  )
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{maxCore}{
Maximal threads to invoke. Ideally \code{maxCore} should not surpass the total logical processors on machine.
}
  \item{agentsCosts}{
A numeric matrix. \code{agentsCosts[i, j]} is the cost for agent \code{i} to finish task \code{j}.
}
  \item{agentsProfits}{
A numeric matrix. \code{agentsProfits[i, j]} is the profit from agent \code{i} finishing task \code{j}.
}
  \item{agentsBudgets}{
A numeric vector. \code{agentsBudgets[i]} is agent \code{j}'s budget.
}
  \item{heuristic}{
A boolean value. If \code{TRUE}, the function returns once it has found a solution whose sum of ranks of the profits becomes no less than that of the optimal. See \code{heuristic} in \code{mmKnapsack()}.
}
  \item{precisionLevel}{
See \code{precisionLevel} in \code{mFLSSSparIntegerized()}.
}
  \item{returnBeforeMining}{
See \code{returnBeforeMining} in \code{mFLSSSparIntegerized()}.
}
  \item{tlimit}{
See \code{tlimit} in \code{FLSSS()}.
}
  \item{useBiSrchInFB}{
See \code{useBiSrchInFB} in \code{FLSSS()}.
}
  \item{threadLoad}{
See \code{avgThreadLoad} in \code{mFLSSSpar()}.
}
  \item{verbose}{
If \code{TRUE}, function prints progress.
}
}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{
See function value of \code{GAP()}.
}
\note{32-bit architecture unsupported.}
\examples{
if(.Machine$sizeof.pointer == 8L){
# =====================================================================================
# 64-bit architecture required.
# =====================================================================================
# =====================================================================================
# Play random numbers
# =====================================================================================
rm(list = ls()); gc()
agents = 5L
tasks = 12L
costs = t(as.data.frame(lapply(1L : agents, function(x) runif(tasks) * 1000)))
budgets = apply(costs, 1, function(x) runif(1, min(x), sum(x)))
profits = t(as.data.frame(lapply(1L : agents, function(x)
  abs(rnorm(tasks) + runif(1, 0, 4)) * 10000)))


# A dirty function for examining the result's integrity. The function takes in
# the task-agent assignment, the profit or cost matrix M, and calculates the cost
# or profit generated by each agent. 'assignment' is a 2-column data
# frame, first column task, second column agent.
agentCostsOrProfits <- function(assignment, M)
{
  n = ncol(M) * nrow(M)
  M2 = matrix(numeric(n), ncol = tasks)
  for(i in 1L : nrow(assignment))
  {
    x = as.integer(assignment[i, ])
    M2[x[2], x[1]] = M[x[2], x[1]]
  }
  apply(M2, 1, function(x) sum(x))
}


dimnames(costs) = NULL
dimnames(profits) = NULL
names(budgets) = NULL

\donttest{
rst = FLSSS::GAPintegerized(maxCore = 2L, agentsCosts = costs, agentsProfits = profits,
                            agentsBudgets = budgets, heuristic = FALSE,
                            precisionLevel = rep(tasks * 4L, agents), tlimit = 2,
                            useBiSrchInFB = FALSE, threadLoad = 8L, verbose = TRUE)


# Function also saves the assignment costs and profits
rst$assignedAgents
rst$assignmentProfit
rst$assignmentCosts


# Examine rst$assignmentCosts
if(sum(rst$assignedAgents) > 0) # all zeros mean the function has not found a solution.
  agentCostsOrProfits(rst$assignedAgents, costs)
# Should equal rst$assignmentCosts and not surpass budgets


# Examine rst$assignmentProfits
if(sum(rst$assignedAgents) > 0)
  sum(agentCostsOrProfits(rst$assignedAgents, profits))
# Should equal rst$assignmentProfit
}



# =====================================================================================
# Test case P03 from
# https://people.sc.fsu.edu/~jburkardt/datasets/generalized_assignment/
# =====================================================================================
agents = 3L
tasks = 8L
profits = matrix(c(
27, 12, 12, 16, 24, 31, 41, 13,
14,  5, 37,  9, 36, 25,  1, 34,
34, 34, 20,  9, 19, 19,  3, 34), ncol = tasks)
costs = matrix(c(
21, 13,  9,  5,  7, 15,  5, 24,
20,  8, 18, 25,  6,  6,  9,  6,
16, 16, 18, 24, 11, 11, 16, 18), ncol = tasks)
budgets = c(26, 25, 34)


rst = FLSSS::GAPintegerized(maxCore = 2L, agentsCosts = costs, agentsProfits = profits,
                            agentsBudgets = budgets, heuristic = FALSE, tlimit = 2,
                            useBiSrchInFB = FALSE, threadLoad = 8L, verbose = TRUE)
agentCostsOrProfits(rst$assignedAgents, costs)
# Should equal rst$assignmentCosts and not surpass budgets


knownOptSolution = as.integer(c(3, 3, 1, 1, 2, 2, 1, 2))
knownOptSolution = data.frame(task = 1L : tasks, agent = knownOptSolution)


# Total profit from knownOptSolution:
sum(agentCostsOrProfits(knownOptSolution, profits))
# Total profit frim FLSSS::GAP():
rst$assignmentProfit
# FLSSS::GAP() generated a better solution.
# =====================================================================================
# =====================================================================================
}
}




