% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AVG_EFFECT.R
\name{AVG_EFFECT}
\alias{AVG_EFFECT}
\title{Compute Estimated Treatment Effects}
\usage{
AVG_EFFECT(CATE_object)
}
\arguments{
\item{CATE_object}{object returned by applying \code{\link{CATE}} function}
}
\value{
estimated treatment effects
}
\description{
\code{AVG_EFFECT} computes estimated treatment effects. Estimated treatment
effect is the weighted average of CATEs, with weight being the number of units
in each matched group.
}
\examples{
data(toy_data)
result <- FLAME::FLAME_bit(data = toy_data, holdout = toy_data)
CATE_object <- FLAME::CATE(FLAME_object = result, cov_name = c("X1", "X2"), cov_val = c("2", "2"))
FLAME::AVG_EFFECT(CATE_object)
}
