% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modSAtree.R
\name{modSAtree}
\alias{modSAtree}
\title{Small area module - Generate small area tree estimates.}
\usage{
modSAtree(
  SApopdatlst = NULL,
  prednames = NULL,
  SApackage = "JoSAE",
  SAmethod = "area",
  estseed = "none",
  woodland = "Y",
  largebnd.unique = NULL,
  landarea = "FOREST",
  pcfilter = NULL,
  estvar = NULL,
  estvar.filter = NULL,
  estvar.derive = NULL,
  rowvar = NULL,
  modelselect = FALSE,
  prior = function(x) 1/(sqrt(x) * (1 + x)),
  na.fill = "NONE",
  savedata = FALSE,
  savesteps = FALSE,
  multest = TRUE,
  returntitle = FALSE,
  table_opts = NULL,
  title_opts = NULL,
  savedata_opts = NULL,
  multest_opts = NULL,
  save4testing = FALSE,
  ...
)
}
\arguments{
\item{SApopdatlst}{List. List of population data objects returned from
modSApop().}

\item{prednames}{String vector. Name(s) of predictor variables to use in
model.}

\item{SApackage}{String. Small area package to use ('JoSAE', 'sae', 'hbsae')}

\item{SAmethod}{String. Small area method to use ('unit', 'area')}

\item{estseed}{String. Use seedling data only or add to tree data. Seedling
estimates are only for counts (estvar='TPA_UNADJ')-('none', 'only', 'add').}

\item{woodland}{String. If woodland = 'Y', include woodland tree species
where measured. If woodland = 'N', only include timber species. See 
FIESTA::ref_species$WOODLAND ='Y/N'. If woodland = 'only', only include
woodland species.}

\item{largebnd.unique}{String. Name of the large boundary unique identifier
to define plots within a model extent. If NULL, all plots are used for model
extent.}

\item{landarea}{String. The sample area filter for estimates ('ALL',
'FOREST', 'TIMBERLAND').  If landarea=FOREST, filtered to COND_STATUS_CD =
1; If landarea=TIMBERLAND, filtered to SITECLCD in(1:6) and RESERVCD = 0.}

\item{pcfilter}{String. A filter for plot or cond attributes (including
pltassgn).  Must be R logical syntax.}

\item{estvar}{String. Name of the tree estimate variable.}

\item{estvar.filter}{String. A tree filter for estimate variable. Must be R
syntax (e.g., "STATUSCD == 1").}

\item{estvar.derive}{List. A derivation of a tree variable to estimate.
Must be a named list with one element (e.g., 
list(SDI='SUM(POWER(DIA/10,1.605) * TPA_UNADJ)'). Set estvar = NULL.}

\item{rowvar}{String. Name of the row domain variable in cond or tree. If
only one domain, rowvar = domain variable. If more than one domain, include
colvar. If no domain, rowvar = NULL.}

\item{modelselect}{Logical. If TRUE, selects useful predictors using
mase:ElasticNet.}

\item{prior}{Function. A prior function to use for hbsae models.}

\item{na.fill}{String. An estimate to fill in for NA values (i.e., when 
model is unstable or no predictors are selected). Choose from the following 
list that does not include SApackage used ('NONE', 'DIR', 'JU.GREG', 
'JU.EBLUP','JFH','hbsaeU','hbsaeA'). DIR is suggested value to fill NA values.}

\item{savedata}{Logical. If TRUE, saves table(s) to outfolder.}

\item{savesteps}{Logical. Saves graphs of predictors and response with
labels whether selected or not for both area- and unit-level models.}

\item{multest}{Logical. If TRUE, returns a data frame of SA estimates using
both unit-level and area-level estimates.}

\item{returntitle}{Logical. If TRUE, returns title(s) of the estimation
table(s).}

\item{table_opts}{List. See help(table_options()) for a list of
options.}

\item{title_opts}{List. See help(title_options()) for a list of options.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}

\item{multest_opts}{List. See help(multest_options()) for a list of options.
Only used when multest = TRUE.}

\item{save4testing}{Logical. If TRUE, saves intermediate steps as R objects
to outfolder for testing (pdomdat, dunitlut).}

\item{...}{Parameters for modSApop() if SApopdat is NULL.}
}
\value{
\item{est}{ Data frame. Tree estimates and percent sampling error by
domain.  Estimates are based on the SApackage and SAmethod parameters
defined. } \item{titlelst}{ List. List of titles used for table output. }
\item{raw}{ List of raw data. If rawdata=TRUE, a list including raw data
components used for calculating estimate. } \item{dunit.multest}{ Data
frame. Table comparing different estimation strategies for SAE. }

Raw data

\item{domdat}{ Data frame. Domain-level data used for estimation. }
\item{estvar}{ String. Name of estimation variable. } \item{estvar.filter}{
String. Logical filter specified for tree data. } \item{dunit.totest}{
String. Table of estimates, including more details. }
}
\description{
Generates small area estimates by domain and/or tree domain (and estimation
unit).
}
\details{
If variables are NULL, then it will prompt user to input variables.

Necessary variables:\cr \tabular{llll}{ \tab \bold{Data} \tab
\bold{Variable} \tab \bold{Description}\cr \tab tree \tab tuniqueid \tab
Unique identifier for each plot, to link to pltstrat (e.g., PLT_CN).\cr \tab
\tab CONDID \tab Unique identifier of each condition on plot, to link to
cond.  Set CONDID=1, if only 1 condition per plot.\cr \tab \tab TPA_UNADJ
\tab Number of trees per acre each sample tree represents (e.g. DESIGNCD=1:
TPA_UNADJ=6.018046 for trees on subplot; 74.965282 for trees on
microplot).\cr \tab cond \tab cuniqueid \tab Unique identifier for each
plot, to link to pltstrat (ex. PLT_CN).\cr \tab \tab CONDID \tab Unique
identifier of each condition on plot.  Set CONDID=1, if only 1 condition per
plot.\cr \tab \tab CONDPROP_UNADJ \tab Unadjusted proportion of condition on
each plot.  Set CONDPROP_UNADJ=1, if only 1 condition per plot.\cr \tab \tab
COND_STATUS_CD \tab Status of each forested condition on plot (i.e.
accessible forest, nonforest, water, etc.)\cr \tab \tab NF_COND_STATUS_CD
\tab If ACI=TRUE. Status of each nonforest condition on plot (i.e.
accessible nonforest, nonsampled nonforest)\cr \tab \tab SITECLCD \tab If
landarea=TIMBERLAND. Measure of site productivity.\cr \tab \tab RESERVCD
\tab If landarea=TIMBERLAND. Reserved status.\cr \tab \tab SUBPROP_UNADJ
\tab Unadjusted proportion of subplot conditions on each plot.  Set
SUBPROP_UNADJ=1, if only 1 condition per subplot.\cr \tab \tab
MICRPROP_UNADJ \tab If microplot tree attributes. Unadjusted proportion of
microplot conditions on each plot. Set MICRPROP_UNADJ=1, if only 1 condition
per microplot.\cr \tab \tab MACRPROP_UNADJ \tab If macroplot tree
attributes. Unadjusted proportion of macroplot conditions on each plot. Set
MACRPROP_UNADJ=1, if only 1 condition per macroplot.\cr \tab pltassign \tab
puniqueid \tab Unique identifier for each plot, to link to cond (ex. CN).\cr
\tab \tab STATECD \tab Identifies state each plot is located in.\cr \tab
\tab INVYR \tab Identifies inventory year of each plot.\cr \tab \tab
PLOT_STATUS_CD \tab Status of each plot (i.e. sampled, nonsampled).  If not
included, all plots are assumed as sampled.\cr }

Reference names are available for the following variables: \cr ADFORCD,
AGENTCD, CCLCD, DECAYCD, DSTRBCD, KINDCD, OWNCD, OWNGRPCD, FORTYPCD,
FLDTYPCD, FORTYPCDCALC, TYPGRPCD, FORINDCD, RESERVCD, LANDCLCD, STDSZCD,
FLDSZCD, PHYSCLCD, MIST_CL_CD, PLOT_STATUS_CD, STATECD, TREECLCD, TRTCD,
SPCD, SPGRPCD
}
\note{
ADJUSTMENT FACTOR:\cr The adjustment factor is necessary to account for
nonsampled conditions.  For model-based estimation, we calculate adjustment
factors by plot.

It is calculated by dividing 1 / summed condition proportions by plot. An
adjustment factor is determined for each tree based on the size of the plot
it was measured on. This is identified using TPA_UNADJ as follows:

\tabular{llr}{ \tab \bold{PLOT SIZE} \tab \bold{TPA_UNADJ} \cr \tab SUBPLOT
\tab 6.018046 \cr \tab MICROPLOT \tab 74.965282 \cr \tab MACROPLOT \tab
0.999188 \cr }

If ACI=FALSE, only nonsampled forest conditions are accounted for in the
adjustment factor. \cr If ACI=TRUE, the nonsampled nonforest conditions are
removed as well and accounted for in adjustment factor.  This is if you are
interested in estimates for all lands or nonforest lands in the
All-Condition-Inventory.

Common tree filters for estvar.filter: \cr

\tabular{llr}{ \tab \bold{FILTER} \tab \bold{DESCRIPTION} \cr \tab "STATUSCD
== 1" \tab Live trees \cr \tab "STATUSCD == 2" \tab Dead trees \cr \tab
"TPAMORT_UNADJ > 0" \tab Mortality trees \cr \tab "STATUSCD == 2 & DIA >=
5.0" \tab Dead trees >= 5.0 inches diameter \cr \tab "STATUSCD == 2 &
AGENTCD == 30" \tab Dead trees from fire \cr }
}
\examples{
\donttest{
# Set up population dataset (see ?modSApop() for more information)
SApopdat <- modSApop(popTabs = list(tree = FIESTA::WYtree,
                                    cond = FIESTA::WYcond),
                     pltassgn = FIESTA::WYpltassgn,
                     pltassgnid = "CN",
                     dunitarea = FIESTA::WYunitarea,
                     dunitvar = "ESTN_UNIT",
                     dunitzonal = FIESTA::WYunitzonal,
                     prednames = c("dem", "tcc", "tpi", "tnt"),
                     predfac = "tnt")

# Use an area level Fay-Herriot model to estimate total net cubic-foot volume 
# of live trees (at least 5 inches diameter) 
modSAtree(SApopdatlst = SApopdat,
          SApackage = "JoSAE",        
          SAmethod = "unit",           
          landarea = "FOREST",      
          estvar = "VOLCFNET",         
          estvar.filter = "STATUSCD = 1")   
}
}
\references{
Breidenbach, J. 2018. JoSAE: Unit-Level and Area-Level Small
Area Estimation.  R package version 0.3.0.
https://CRAN.R-project.org/package=JoSAE.

Molina I, Marhuenda Y. 2015. sae: An R Package for Small Area Estimation.
The R Journal 7(1), 81-98.
https://journal.r-project.org/archive/2015/RJ-2015-007/RJ-2015-007.
}
\author{
Tracey S. Frescino, Paul L. Patterson, Elizabeth A. Freeman
}
\keyword{data}
