% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_stats.R
\name{classtable}
\alias{classtable}
\title{Compute classification statistics for binary prediction and criterion (e.g.; truth) vectors}
\usage{
classtable(
  prediction_v = NULL,
  criterion_v = NULL,
  correction = 0.25,
  sens.w = NULL,
  cost.outcomes = NULL,
  cost_v = NULL,
  my.goal = NULL,
  my.goal.fun = NULL,
  quiet_mis = FALSE,
  na_prediction_action = "ignore"
)
}
\arguments{
\item{prediction_v}{logical. A logical vector of predictions.}

\item{criterion_v}{logical. A logical vector of (TRUE) criterion values.}

\item{correction}{numeric. Correction added to all counts for calculating \code{dprime}.
Default: \code{correction = .25}.}

\item{sens.w}{numeric. Sensitivity weight parameter (from 0 to 1, for computing \code{wacc}).
Default: \code{sens.w = NULL} (to ensure that values are passed by calling function).}

\item{cost.outcomes}{list. A list of length 4 with names 'hi', 'fa', 'mi', and 'cr' specifying
the costs of a hit, false alarm, miss, and correct rejection, respectively.
For instance, \code{cost.outcomes = listc("hi" = 0, "fa" = 10, "mi" = 20, "cr" = 0)} means that
a false alarm and miss cost 10 and 20, respectively, while correct decisions have no cost.
Default: \code{cost.outcomes = NULL} (to ensure that values are passed by calling function).}

\item{cost_v}{numeric. Additional cost value of each decision (as an optional vector of numeric values).
Typically used to include the cue cost of each decision (as a constant for the current level of an FFT).
Default: \code{cost_v = NULL} (to ensure that values are passed by calling function).}

\item{my.goal}{Name of an optional, user-defined goal (as character string). Default: \code{my.goal = NULL}.}

\item{my.goal.fun}{User-defined goal function (with 4 arguments \code{hi fa mi cr}). Default: \code{my.goal.fun = NULL}.}

\item{quiet_mis}{A logical value passed to hide/show \code{NA} user feedback
(usually \code{x$params$quiet$mis} of the calling function).
Default: \code{quiet_mis = FALSE} (i.e., show user feedback).}

\item{na_prediction_action}{What happens when no prediction is possible? (Experimental and currently unused.)}
}
\description{
The main input are 2 logical vectors of prediction and criterion values.
}
\details{
The primary confusion matrix is computed by \code{\link{confusionMatrix}} of the \strong{caret} package.
}
