% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{nobs.femlm}
\alias{nobs.femlm}
\title{Extract the number of observations form a femlm object}
\usage{
\method{nobs}{femlm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{femlm}. Typically the result of a \code{\link[FENmlm]{femlm}} estimation.}

\item{...}{Not currently used.}
}
\value{
It returns an interger.
}
\description{
This function simply extracts the number of obsrvations used to estimate a \code{\link[FENmlm]{femlm}} model.
}
\examples{

# simple estimation on iris data, clustering by "Species"
res = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
            Petal.Width | Species, iris)

nobs(res)
logLik(res)


}
\seealso{
See also the main estimation functions \code{\link[FENmlm]{femlm}}. Use \code{\link[FENmlm]{summary.femlm}} to see the results with the appropriate standard-errors, \code{\link[FENmlm]{getFE}} to extract the cluster coefficients, and the functions \code{\link[FENmlm]{res2table}} and \code{\link[FENmlm]{res2tex}} to visualize the results of multiple estimations.
}
\author{
Laurent Berge
}
