% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{n.fdr.signtest}
\alias{n.fdr.signtest}
\title{Sample size calculation for sign tests}
\usage{
n.fdr.signtest(fdr, pwr, p, pi0.hat = "BH")
}
\arguments{
\item{fdr}{desired FDR (scalar numeric)}

\item{pwr}{desired average power (scalar numeric)}

\item{p}{Pr(X>0), as in Noether (JASA 1987)}

\item{pi0.hat}{approximation method for null proportion}
}
\value{
A list with the following components:
\item{n}{a sample size estimate}
\item{computed.avepow}{average power}
\item{desired.avepow}{desired average power}
\item{desired.fdr}{desired FDR}
\item{input.pi0}{proportion of tests with a true null hypothesis}
\item{alpha}{fixed p-value threshold for multiple testing procedure}
\item{n.its}{number of iteration}
\item{max.its}{maximum number of iteration, default is 50}
\item{n0}{lower limit for initial sample size range}
\item{n1}{upper limit for initial sample size range}
}
\description{
Find the sample size needed to have a desired false discovery rate and average power for a large number of sign tests.
}
\examples{
p = rep(c(0.8, 0.5), c(100, 900));
n.fdr.signtest(fdr = 0.1, pwr = 0.8, p = p, pi0.hat = "BH")
}
\references{
Noether, Gottfried E (1987) Sample size determination for some common nonparametric tests. Journal of the American Statistical Association, 82:645-647.
}
