% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_post.R
\name{summary.MVWN_stats}
\alias{summary.MVWN_stats}
\title{Summarize Statistics for Multivariate White Noise Tests}
\usage{
\method{summary}{MVWN_stats}(object, ...)
}
\arguments{
\item{object}{An S3 object of type \code{MVWN_stats} containing the results
from multivariate tests for white noise.
It is the output of \code{MVWNtest}.}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
\code{summary.MVWN_stats} is an S3 method for objects of class \code{MVWN_stats}
that prints a summary of the statistics from \code{MVWNtest} to screen.
\code{MVWNtest} performs multivariate tests for white noise.
It performs both the Ljung-Box Q-test and the LM-test on individual series
for a sequence of lag lengths.
}
\note{
The LM test is consistent for heteroskedastic series, the Q-test is not.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
results <- FCVARestn(x, k = 2, r = 1, opt)
MVWNtest_stats <- MVWNtest(x = results$Residuals, maxlag = 12, printResults = 1)
summary(object = MVWNtest_stats)
}

\donttest{
set.seed(27)
WN <- stats::rnorm(100)
RW <- cumsum(stats::rnorm(100))
MVWN_x <- as.matrix(data.frame(WN = WN, RW = RW))
MVWNtest_stats <- MVWNtest(x = MVWN_x, maxlag = 10, printResults = 1)
summary(object = MVWNtest_stats)
}
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} produces the residuals intended for this test.
\code{LagSelect} uses this test as part of the lag order selection process.
\code{summary.MVWN_stats} is an S3 method for class \code{MVWN_stats} that
prints a summary of the output of \code{MVWNtest} to screen.

Other FCVAR postestimation functions: 
\code{\link{FCVARboot}()},
\code{\link{FCVARhypoTest}()},
\code{\link{GetCharPolyRoots}()},
\code{\link{MVWNtest}()},
\code{\link{plot.FCVAR_roots}()},
\code{\link{summary.FCVAR_roots}()}
}
\concept{FCVAR postestimation functions}
