% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyDetrend.R
\name{polyDetrend}
\alias{polyDetrend}
\title{Polynomial detrending of a time series}
\usage{
polyDetrend(f, acqTime, nIntervals, degree = 3, plot = TRUE)
}
\arguments{
\item{f}{A vector}

\item{acqTime}{Point acquisition rate (in seconds)}

\item{nIntervals}{Number of intervals into which the vector will be grouped before a polynomial model fit}

\item{degree}{The degree of the polynomial function}

\item{plot}{Boolean, set to TRUE (default) to plot the result}
}
\value{
A vector
}
\description{
Performs the polynomial detrending algorithm over a vector
}
\details{
First, the binTimeSeries() function is used to obtain a binned version of 'f' of 'nIntervals' points.
A polynomial model of user-specified degree is then adjusted to the binned vector. The full time series is then
evaluated using the obtained model and the residuals are calculated. Finally, the maximum value of the fitted time
series is added to the residuals for trend correction.
}
\examples{
\donttest{
### Please navigate to
### (https://github.com/FCSlib/FCSlib/tree/master/Sample\%20Data)
### to find this sample data

x <- read.table("PB030.dat", header = F)

x.d <- polyDetrend(x[,2], acqTime = 4e-6, nIntervals = 100, degre = 5)
}
}
\seealso{
\code{\link{expDetrend} \link{boxcarDetrend} \link{binTimeSeries}}
}
\author{
Alejandro Linares, Adan Guerrero, Haydee Hernández
}
