% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp_net.R
\docType{class}
\name{mlp_net-class}
\alias{mlp_net-class}
\alias{mlp_net-method}
\alias{show,mlp_net-method}
\alias{summary,mlp_net-method}
\title{An S4 class representing Multilayer Perception Network.}
\description{
The \code{mlp_net} class represents the Multilayer Perception Network
employing the so-called compressed representation, which was inspired
by the Compressed Column Storage familiar from sparse matrix algebra.
Although the representation and algorithms working with it are somewhat
complicated, the user is provided with a simple and intuitive interface
that completely hides the internal workings of the package, which in its
large part is written in C++.
}
\section{Slots}{

\describe{
\item{\code{m_name}}{character string, network name}

\item{\code{m_layers}}{integer vector, stores the numbers of neurons in layers}

\item{\code{m_n_pointers}}{integer vector, stores the so-called 'pointers' to neurons}

\item{\code{m_n_prev}}{integer vector, stores the number of connected neurons in the previous layer}

\item{\code{m_n_next}}{integer vector, stores the number of connected neurons in the next layer}

\item{\code{m_w_pointers}}{integer vector, stores the so-called 'pointers' to weights}

\item{\code{m_w_values}}{numeric vector, values of connection weights and biases}

\item{\code{m_w_flags}}{logical vector, states (active/inactive) of weights and biases}

\item{\code{m_w_on}}{integer value, the number of active weights}

\item{\code{m_af}}{integer vector, activation functions' indices}

\item{\code{m_af_p}}{numeric vector, activation functions' slope parameters}
}}
\references{
G. Klima. \emph{A new approach towards implementing artificial neural networks.}
Technical Report, \url{http://fcnn.sourceforge.net/}, 2013.
}
\seealso{
\code{\link{mlp_net}} for creating objects of this class.
}
\keyword{classes}

