context('Estimate FAVAR')

data('regdata')
fit <- FAVAR(Y = regdata[,c("Inflation","Unemployment","Fed_funds")],
             X = regdata[,1:115], slowcode = slowcode,fctmethod = 'BBE',
             factorprior = list(b0 = 0, vb0 = NULL, c0 = 0.01, d0 = 0.01),
             varprior = list(b0 = 0,vb0 = 0, nu0 = 0, s0 = 0),
             nrep = 100, nburn = 10, K = 2, plag = 2,  ncores = 1)
dtirf <- irf(fit,resvar = 2, tcode = tcode)

lamb_tol <- sum((abs(colMeans(fit$Lamb[,,6])) - abs(c(0.8172659, 0.6471958, 0.2963342, 0.1737213, 0.2347369)))^2)

varcoef_tol <- sum((abs(rowMeans(fit$varrlt$A)) - abs(c(0.778129386, -0.603017504,  0.213206464,  0.325159327, -0.100403434,
                                      0.149940841,  0.853207800,  0.286029475, -0.321815773,  0.681410053,
                                      0.031195983,  0.009408599,  1.028526266, -0.031933855,  0.240291022,
                                    -0.212201285,  0.437870305, -0.024441733, 0.749676918,  0.130926541,
                                    0.055975167, -0.078032560, -0.060970421, -0.013329282,  0.791751571,
                                    0.186799661,  0.046754597,  0.251181251,  0.150234164,  0.061598555,
                                    -0.048730709,  0.001875996,  0.061739936, 0.138572123, -0.370153282,
                                    -0.046645148,  0.121886463, -0.184829209,  0.024781678, -0.208729971,
                                    0.159108630, -0.416506794,  0.024704619,  0.198934484, -0.150351969,
                                    -0.008916529,  0.014557877,  0.046474131,  0.025599617,  0.159949583)))^2)

irf_tol <- sum((rowMeans(sapply(dtirf$imp, function(x) x[2,])) -
  c(-0.06851129, -0.13232879, -0.32971814, -0.51434825, -0.64979011, -0.74314192,
    -0.80345666, -0.84062401, -0.86199900, -0.87239392))^2)

# test
test_that('loading factor', expect_true(lamb_tol < 0.01))
test_that('coefficients VAR', expect_true(varcoef_tol < 0.01))
test_that('IRF', expect_true(irf_tol < 0.01))
