% Generated by roxygen2 (4.0.0): do not edit by hand
\name{Beta.ab}
\alias{Beta.ab}
\alias{dBeta.ab}
\alias{eBeta.ab}
\alias{lBeta.ab}
\alias{pBeta.ab}
\alias{qBeta.ab}
\alias{rBeta.ab}
\alias{sBeta.ab}
\title{The four-Parameter beta Distribution.}
\usage{
dBeta.ab(x, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b))

pBeta.ab(q, shape1 = 2, shape2 = 3, a = 0, b = 1, params = list(shape1
  = 2, shape2 = 5, a = 0, b = 1))

qBeta.ab(p, shape1 = 2, shape2 = 3, a = 0, b = 1, params = list(shape1
  = 2, shape2 = 5, a = 0, b = 1))

rBeta.ab(n, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b))

eBeta.ab(X, w, method = "numerical.MLE")

lBeta.ab(X, w, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b), logL = TRUE)

sBeta.ab(X, w, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b))
}
\arguments{
\item{params}{a list includes all parameters}

\item{x,q}{vector of quantiles.}

\item{w}{weights of sample.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{shape1,shape2}{shape parameters.}

\item{a,b}{boundary parameters.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lBeta.ab gives log likelihood.}

\item{...}{other parameters}
}
\value{
dBeta.ab gives the density; pBeta.ab gives the distribution function;
qBeta.ab gives the quantile function; rBeta.ab generates random variables;
eBeta.ab estimate the parameters; sBeta.ab gives observed scorn function
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the 4 Parameter beta distribution
}
\details{
\itemize{
 \item{Probability density function:}
 \deqn{f(x) = \frac{x^{\alpha-1}(1-x)^{\beta-1}} {\mathcal{B}(\alpha,\beta)}}
 with \eqn{\alpha} and \eqn{\beta} two shape parameters and \eqn{\mathcal B} beta function
 \item{Cumulative distribution function:}
 \deqn{F(x) = \frac{\int_{0}^{x} y^{\alpha-1}(1-y)^{\beta-1}dy} {\mathcal{B}(\alpha,\beta)}
 =\mathcal{B}(x; \alpha,\beta)} with \eqn{\mathcal B (x; \alpha,\beta)} being incomplete beta function.
 \item{Log-likelihood function:}
 \deqn{L(\alpha,\beta;X)=\sum_i\left[ (\alpha-1)\ln(x)+(\beta-1)\ln(1-x)-\ln \mathcal{B}(\alpha,\beta) \right]}
 \item{Score function vector:}
 \deqn{V(\mu,\sigma;X)
 =\left( \begin{array}{c}
 \frac{\partial L}{\partial \alpha}  \\
 \frac{\partial L}{\partial \beta}
 \end{array} \right)
 =\sum_i
 \left( \begin{array}{c}
 \psi^{(0)}(\alpha+\beta)-\psi^{(0)}(\alpha)+\ln(x) \\
 \psi^{(0)}(\alpha+\beta)-\psi^{(0)}(\beta)+\ln(x)
 \end{array} \right)
 }
 with \eqn{\psi^{(0)}} being log-gamma function.
 \item{Observed information matrix:}
 \deqn{\mathcal J (\mu,\sigma;X)=
 \left( \begin{array}{cc}
 \psi^{(1)}(\alpha)-\psi^{(1)}(\alpha+\beta) & -\psi^{(1)}(\alpha+\beta) \\
 -\psi^{(1)}(\alpha+\beta) & \psi^{(1)}(\beta)-\psi^{(1)}(\alpha+\beta) \end{array} \right)
 }
 with \eqn{\psi^{(1)}} being digamma function.
}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
a <- 1
b <- 2
shape1 <- 2
shape2 <- 5
X <- rBeta.ab(n, shape1, shape2, a, b)
(est.par <- eBeta.ab(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dBeta.ab(den.x,params = est.par)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qBeta.ab((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(a,b), ylim = c(a,b))
abline(0,1)

plot((1:n-0.5)/n, pBeta.ab(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(shape1=2, shape2=5, a= 1, b=2)
X <- rBeta.ab(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eBeta.ab(X,w) # estimated parameters of weighted sample
eBeta.ab(X) # estimated parameters of unweighted sample

# Extracting shape parameters
est.par[attr(est.par,"par.type")=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rBeta.ab,edist=eBeta.ab,n = 1000, rep.num = 1e3,
params = list(shape1=2, shape2=5, a=0, b=1), method ="numerical.MLE")

# evaluate the precision of estimation by Hessian matrix
X <- rBeta.ab(1000, shape1, shape2, a, b)
(est.par <- eBeta.ab(X))
H <- attr(eBeta.ab(X, method = "numerical.MLE"),"nll.hessian")
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lBeta.ab(X,param = est.par)
lBeta.ab(X,param = est.par, logL=FALSE)
sBeta.ab(X,param = est.par)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

